package eu.dnetlib.clients.enabling.database.ws;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.enabling.DatabaseService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.EPRUtils;

public class DatabaseServiceClient implements DatabaseService {

	private static Logger logger = Logger
			.getLogger(DatabaseServiceClient.class);

	private eu.dnetlib.enabling.database.rmi.DatabaseService dbService;

	@Override
	public void importFromEPR(String db, EPR epr, String xslt) {
		try {
			dbService.importFromEPR(db, EPRUtils.createW3CEPR(epr), xslt);

		} catch (Exception e) {
			logger.error("Error importing from epr", e);
		}
	}

	public void setDbService(
			eu.dnetlib.enabling.database.rmi.DatabaseService dbService) {
		this.dbService = dbService;
	}

	public void setWebService(Object dbService) {
		this.dbService = (eu.dnetlib.enabling.database.rmi.DatabaseService) dbService;
	}

	@Override
	@Deprecated
	public ServiceIdentity identify() {
		throw new UnsupportedOperationException();
	}

	@Override
	@Deprecated
	public void notify(Notification notification) throws DriverServiceException {
		throw new UnsupportedOperationException();
	}
}