package eu.dnetlib.clients.enabling.isregistry.ws;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ISRegistryService;
import eu.dnetlib.api.enabling.ISRegistryServiceException;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;

public class ISRegistryClient implements ISRegistryService {
	private static Logger logger = Logger.getLogger(ISRegistryClient.class);
	
	private eu.dnetlib.enabling.is.registry.rmi.ISRegistryService isRegistry = null;

	public void setIsRegistry(eu.dnetlib.enabling.is.registry.rmi.ISRegistryService isRegistry) {
		this.isRegistry = isRegistry;
	}

	public void setWebService(Object webService) {
		this.isRegistry = (eu.dnetlib.enabling.is.registry.rmi.ISRegistryService) webService;
	}
	@Override
	public boolean deleteProfile(String profId)
			throws ISRegistryServiceException {
		try {
			return isRegistry.deleteProfile(profId);
		} catch (ISRegistryException e) {
			throw new ISRegistryServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISRegistryServiceException("Error deleting profile");
		}
	}

	@Override
	public String insertProfileForValidation(String resourceType,
			String resourceProfile) throws ISRegistryServiceException {
		try {
			return isRegistry.insertProfileForValidation(resourceType, resourceProfile);
		} catch (ISRegistryException e) {
			throw new ISRegistryServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISRegistryServiceException("Error inserting profile for validation");
		}
	}

	@Override
	public String registerProfile(String resourceProfile)
			throws ISRegistryServiceException {
		try {
			return isRegistry.registerProfile(resourceProfile);
		} catch (ISRegistryException e) {
			throw new ISRegistryServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISRegistryServiceException("Error registering profile");
		}
	}

	@Override
	public String registerSecureProfile(String resourceProfID,
			String secureProfID) throws ISRegistryServiceException {
		try {
			return isRegistry.registerSecureProfile(resourceProfID, secureProfID);
		} catch (ISRegistryException e) {
			throw new ISRegistryServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISRegistryServiceException("Error registering secure profile");
		}
	}

	@Override
	public boolean updateProfile(String profId, String resourceProfile,
			String resourceType) throws ISRegistryServiceException {
		try {
			return isRegistry.updateProfile(profId, resourceProfile, resourceType);
		} catch (ISRegistryException e) {
			throw new ISRegistryServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISRegistryServiceException("Error updating profile");
		}
	}

	@Override
	public boolean addResourceType(String resourceType, String resourceSchema)
	throws ISRegistryServiceException {
		try {
			return isRegistry.addResourceType(resourceType, resourceSchema);
		} catch (ISRegistryException e) {
			throw new ISRegistryServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISRegistryServiceException("Error adding schema");
		}
	}
	
	@Override
	public ServiceIdentity identify() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void notify(Notification notification) {
		// TODO Auto-generated method stub
		throw new UnsupportedOperationException();		
	}
}
