package eu.dnetlib.clients.functionality.collection.ws;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.api.functionality.CollectionService;
import eu.dnetlib.clients.ws.DriverWebService;
import eu.dnetlib.domain.functionality.Collection;
import eu.dnetlib.domain.functionality.CollectionSearchCriteria;

@WebService
public interface CollectionWebService extends DriverWebService<CollectionService> {

	@WebMethod(operationName = "getCollection")
	public Collection getCollection(
			@WebParam(name = "collectionId") String collectionId)
			throws CollectionWebServiceException;

	@WebMethod(operationName = "getCollections")
	public List<Collection> getCollections(
			@WebParam(name = "collectionIds") List<String> collectionIds)
			throws CollectionWebServiceException;

	@WebMethod(operationName = "updateCollection")
	public void updateCollection(
			@WebParam(name = "collection") Collection collection)
			throws CollectionWebServiceException;

	@WebMethod(operationName = "deleteCollection")
	public void deleteCollection(
			@WebParam(name = "collectionId") String collectionId)
			throws CollectionWebServiceException;

	@WebMethod(operationName = "createCollection")
	public String createCollection(
			@WebParam(name = "collection") Collection collection)
			throws CollectionWebServiceException;
	
	@WebMethod(operationName = "searchCollections")
	public List<Collection> searchCollections(
			@WebParam(name = "criteria") CollectionSearchCriteria criteria)
			throws CollectionWebServiceException;
}