package eu.dnetlib.clients.functionality.collection.ws;

import java.util.ArrayList;
import java.util.List;

import eu.dnetlib.api.functionality.CollectionService;
import eu.dnetlib.api.functionality.CollectionServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.Collection;
import eu.dnetlib.domain.functionality.CollectionSearchCriteria;

public class CollectionWebServiceClient
		extends BaseWebServiceClient<CollectionWebService>
		implements CollectionService {
	
	@Override
	public String createCollection(Collection collection)
			throws CollectionServiceException {
		try {
			return webService.createCollection(collection);
		} catch (CollectionWebServiceException e) {
			throw new CollectionServiceException(e);
		}
	}

	@Override
	public void deleteCollection(String collectionId)
			throws CollectionServiceException {
		try {
			webService.deleteCollection(collectionId);
		} catch (CollectionWebServiceException e) {
			throw new CollectionServiceException(e);
		}
	}

	@Override
	public Collection getCollection(String collectionId)
			throws CollectionServiceException {
		try {
			return webService.getCollection(collectionId);
		} catch (CollectionWebServiceException e) {
			throw new CollectionServiceException(e);
		}
	}

	@Override
	public List<Collection> getCollections(List<String> collectionIds)
			throws CollectionServiceException {
		try {
			List<Collection> list = webService.getCollections(collectionIds);
			
			return (list != null)?list:new ArrayList<Collection>();
		} catch (CollectionWebServiceException e) {
			throw new CollectionServiceException(e);
		}
	}

	@Override
	public void updateCollection(Collection collection)
			throws CollectionServiceException {
		try {
			webService.updateCollection(collection);
		} catch (CollectionWebServiceException e) {
			throw new CollectionServiceException(e);
		}
	}

	@Override
	public List<Collection> searchCollections(CollectionSearchCriteria criteria)
			throws CollectionServiceException {
		try {
			List<Collection> list = webService.searchCollections(criteria);
			
			return (list != null)?list:new ArrayList<Collection>();
		} catch (CollectionWebServiceException e) {
			throw new CollectionServiceException(e);
		}
	}
}
