package eu.dnetlib.clients.functionality.collection.ws;

import java.util.ArrayList;
import java.util.List;

import javax.jws.WebService;

import eu.dnetlib.api.functionality.CollectionService;
import eu.dnetlib.api.functionality.CollectionServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.Collection;
import eu.dnetlib.domain.functionality.CollectionSearchCriteria;

@WebService(
		endpointInterface = "eu.dnetlib.clients.functionality.collection.ws.CollectionWebService")
public class CollectionWebServiceImpl 
		extends BaseDriverWebService<CollectionService>
		implements CollectionWebService {
	
	@Override
	public String createCollection(Collection collection)
			throws CollectionWebServiceException {
		try {
			return service.createCollection(collection);
		} catch (CollectionServiceException e) {
			throw new CollectionWebServiceException(e);
		}
	}

	@Override
	public void deleteCollection(String collectionId)
			throws CollectionWebServiceException {
		try {
			service.deleteCollection(collectionId);
		} catch (CollectionServiceException e) {
			throw new CollectionWebServiceException(e);
		}
	}

	@Override
	public Collection getCollection(String collectionId)
			throws CollectionWebServiceException {
		try {
			return service.getCollection(collectionId);
		} catch (CollectionServiceException e) {
			throw new CollectionWebServiceException(e);
		}
	}

	@Override
	public List<Collection> getCollections(List<String> collectionIds)
			throws CollectionWebServiceException {
		try {
			return service.getCollections(collectionIds);
		} catch (CollectionServiceException e) {
			throw new CollectionWebServiceException(e);
		}
	}

	@Override
	public void updateCollection(Collection collection)
			throws CollectionWebServiceException {
		try {
			service.updateCollection(collection);
		} catch (CollectionServiceException e) {
			throw new CollectionWebServiceException(e);
		}
	}

	@Override
	public List<Collection> searchCollections(CollectionSearchCriteria criteria)
			throws CollectionWebServiceException {
		try {
			List<Collection> res = service.searchCollections(criteria);
			
			return (res != null)?res:new ArrayList<Collection>();
		} catch (CollectionServiceException e) {
			throw new CollectionWebServiceException(e);
		}
	}
}