package eu.dnetlib.clients.functionality.profile.ws;

import java.util.ArrayList;
import java.util.List;

import eu.dnetlib.api.functionality.UserProfileService;
import eu.dnetlib.api.functionality.UserProfileServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.domain.functionality.UserProfileSearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;

public class CheatingWSClient extends
		BaseWebServiceClient<UserProfileWebService> implements
		UserProfileService {

	private ISLookUp<UserProfile> userLookup = null;

	@Override
	public void deleteUser(UserProfile profile)
			throws UserProfileServiceException {
		try {
			webService.deleteUserById(profile.getResourceId());
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public void deleteUserById(String id) throws UserProfileServiceException {
		try {
			webService.deleteUserById(id);
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public UserProfile getUserById(String id)
			throws UserProfileServiceException {
		try {
			return userLookup.getById(id);
		} catch (ISLookUpException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public UserProfile saveUser(UserProfile profile)
			throws UserProfileServiceException {
		try {
			return webService.saveUser(profile);
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public List<String> searchUserIds(UserProfileSearchCriteria criteria)
			throws UserProfileServiceException {
		try {
			List<UserProfile> users = userLookup.fetch(criteria);
			List<String> ids = new ArrayList<String>();

			for (UserProfile user : users)
				ids.add(user.getResourceId());

			return ids;
		} catch (ISLookUpException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public List<UserProfile> searchUsers(UserProfileSearchCriteria criteria)
			throws UserProfileServiceException {
		try {
			List<UserProfile> users = userLookup.fetch(criteria);

			return users;
		} catch (ISLookUpException e) {
			throw new UserProfileServiceException(e);
		}
	}

	public ISLookUp<UserProfile> getUserLookup() {
		return userLookup;
	}

	public void setUserLookup(ISLookUp<UserProfile> userLookup) {
		this.userLookup = userLookup;
	}
}