/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.functionality.alert.ws;

import eu.dnetlib.api.functionality.AlertService;
import eu.dnetlib.api.functionality.AlertServiceException;
import eu.dnetlib.clients.functionality.alert.ws.AlertWebService;
import eu.dnetlib.clients.functionality.alert.ws.AlertWebServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.AlertSubscription;
import eu.dnetlib.domain.functionality.AlertTemplate;
import eu.dnetlib.domain.functionality.NotificationEvent;
import eu.dnetlib.domain.functionality.ObjectPage;
import eu.dnetlib.domain.functionality.ResultPage;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jws.WebService;

@WebService(serviceName="AlertWebService", endpointInterface="eu.dnetlib.clients.functionality.alert.ws.AlertWebService")
public class AlertWebServiceImpl
extends BaseDriverWebService<AlertService>
implements AlertWebService {
    @Override
    public SortedSet<String> getSupportedAlertModes() {
        SortedSet supportedAlertModes = ((AlertService)this.service).getSupportedAlertModes();
        return supportedAlertModes == null ? new TreeSet() : supportedAlertModes;
    }

    @Override
    public ObjectPage<AlertTemplate> getTemplates(int pageNumber, int pageSize) throws AlertWebServiceException {
        try {
            return ((AlertService)this.service).getTemplates(pageNumber, pageSize);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error retrieving templates (page: " + pageNumber + ", page size: " + pageSize + ")", e);
        }
    }

    @Override
    public void addTemplate(AlertTemplate template) throws AlertWebServiceException {
        try {
            ((AlertService)this.service).addTemplate(template);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error adding template " + template, e);
        }
    }

    @Override
    public void removeTemplate(String templateId) throws AlertWebServiceException {
        try {
            ((AlertService)this.service).removeTemplate(templateId);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error removing template " + templateId, e);
        }
    }

    @Override
    public ObjectPage<AlertSubscription> getSubscriptions(int pageNumber, int pageSize) throws AlertWebServiceException {
        try {
            return ((AlertService)this.service).getSubscriptions(pageNumber, pageSize);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error retrieving subscriptions (page: " + pageNumber + ", page size: " + pageSize, e);
        }
    }

    @Override
    public SortedSet<AlertSubscription> getSubscriptions(String alertMode, String subscriber, int limit, int offset) throws AlertWebServiceException {
        try {
            SortedSet subscriptions = ((AlertService)this.service).getSubscriptions(alertMode, subscriber, limit, offset);
            return subscriptions == null ? new TreeSet() : subscriptions;
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error retrieving subscriptions with alert mode " + alertMode + " and subscriber like '" + subscriber + "' (limit: " + limit + ", offset: " + offset + ")", e);
        }
    }

    @Override
    public void addSubscription(AlertSubscription subscription) throws AlertWebServiceException {
        try {
            ((AlertService)this.service).addSubscription(subscription);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error adding subscription " + subscription, e);
        }
    }

    @Override
    public void enableSubscription(String templateId, URL notificationService, String queryId, String resultId, String alertMode, URI subscriber) throws AlertWebServiceException {
        try {
            ((AlertService)this.service).enableSubscription(templateId, notificationService, queryId, resultId, alertMode, subscriber);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error enabling subscription (template: " + templateId + ", notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", alert mode: " + alertMode + ", subscriber: " + subscriber + ")", e);
        }
    }

    @Override
    public void disableSubscription(String templateId, URL notificationService, String queryId, String resultId, String alertMode, URI subscriber) throws AlertWebServiceException {
        try {
            ((AlertService)this.service).disableSubscription(templateId, notificationService, queryId, resultId, alertMode, subscriber);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error disabling subscription (template: " + templateId + ", notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", alert mode: " + alertMode + ", subscriber: " + subscriber + ")", e);
        }
    }

    @Override
    public void removeSubscription(String templateId, URL notificationService, String queryId, String resultId, String alertMode, URI subscriber) throws AlertWebServiceException {
        try {
            ((AlertService)this.service).removeSubscription(templateId, notificationService, queryId, resultId, alertMode, subscriber);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error removing subscription (template: " + templateId + ", notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", alert mode: " + alertMode + ", subscriber: " + subscriber + ")", e);
        }
    }

    @Override
    public int countAlertResults(URL notificationService, String queryId, Date date, String resultId) throws AlertWebServiceException {
        try {
            return ((AlertService)this.service).countAlertResults(notificationService, queryId, date, resultId);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error counting alert results (notification service: " + notificationService + ", query: " + queryId + ", date: " + date + ", result: " + resultId + ")", e);
        }
    }

    @Override
    public ResultPage getAlertResults(URL notificationService, String queryId, String resultId, Date fromDate, Date toDate, int limit, int offset) throws AlertWebServiceException {
        try {
            return ((AlertService)this.service).getAlertResults(notificationService, queryId, resultId, fromDate, toDate, limit, offset);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error retrieving alert results (notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset);
        }
    }

    @Override
    public void alert(URL notificationService, NotificationEvent event) throws AlertWebServiceException {
        try {
            ((AlertService)this.service).alert(notificationService, event);
        }
        catch (AlertServiceException e) {
            throw new AlertWebServiceException("error receiving notification from notification service " + notificationService + " about event " + event);
        }
    }
}

