package eu.dnetlib.clients.functionality.rating.ws;

import java.util.ArrayList;
import java.util.List;

import eu.dnetlib.api.functionality.RatingService;
import eu.dnetlib.api.functionality.RatingServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.Rating;

/**
 * This class implements rating service using a rating web service.
 * @author thanos@di.uoa.gr
 *
 */
public class RatingWebServiceClient
	extends BaseWebServiceClient<RatingWebService>
	implements RatingService {
	
	@Override
	public List<Rating> getTopDocuments(int limit) throws RatingServiceException {
		try {
			List<Rating> topDocuments = webService.getTopDocuments(limit);
			return (topDocuments == null ? new ArrayList<Rating>() : topDocuments);
		} catch (RatingWebServiceException e) {
			throw new RatingServiceException(e);
		}
	}

	@Override
	public List<Rating> getTopRatings(int limit) throws RatingServiceException {
		try {
			List<Rating> topRatings = webService.getTopRatings(limit);
			return (topRatings == null ? new ArrayList<Rating>() : topRatings);
		} catch (RatingWebServiceException e) {
			throw new RatingServiceException(e);
		}
	}

	@Override
	public void rate(String userId, String documentId, float score) throws RatingServiceException {
		try {
			webService.rate(userId, documentId, score);
		} catch (RatingWebServiceException e) {
			throw new RatingServiceException(e);
		}
	}

	@Override
	public List<Rating> searchRatingsByDocument(String documentId) throws RatingServiceException {
		try {
			List<Rating> ratings = webService.searchRatingsByDocument(documentId);
			return (ratings == null ? new ArrayList<Rating>() : ratings);
		} catch (RatingWebServiceException e) {
			throw new RatingServiceException(e);
		}
	}

	@Override
	public List<Rating> searchRatingsByUser(String userId) throws RatingServiceException {
		try {
			List<Rating> ratings = webService.searchRatingsByUser(userId);
			return (ratings == null ? new ArrayList<Rating>() : ratings);
		} catch (RatingWebServiceException e) {
			throw new RatingServiceException(e);
		}
	}
}
