package eu.dnetlib.clients.utils.ws;

import java.lang.reflect.InvocationTargetException;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.utils.resolver.ServiceClientFactory;

/**
 * This is an implementation of ServiceClientFactory for web service transport
 * layer. This implementation assumes that all service interfaces are part of
 * the DriverService hierarchy, but does not require that the web service
 * interfaces belong to the DriverWebService hierarchy.
 * 
 * This implementation is created for dnet1.1, where there is no common API for
 * all partners and the only transport layer is SOAP based for all services.
 * 
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 * 
 */
public class CompatibilityServiceClientFactory<S extends DriverService> implements ServiceClientFactory<S> {
	private CompatibilityTransportConfiguration config = null;
	private static Logger logger = Logger.getLogger(CompatibilityServiceClientFactory.class);
	
	private Class<S> serviceClass = null;

	/**
	 * Creates a client for a service that does not provide a DriverWebService
	 * endpoint. The assumption made here is that the service client provides a
	 * default constructor and a setWebService(Object webService) method.
	 * 
	 * @param <T>
	 *            The service type.
	 * @param serviceClass
	 *            The service class.
	 * @param endpoint
	 *            The web service endpoint.
	 * 
	 * @return A client for this web service.
	 */
	public S newClient(Object endpoint) {
		if (logger.isDebugEnabled())
			logger.debug("Creating client for service "
					+ serviceClass.getName() + " and endpoint of class "
					+ endpoint.getClass().getName());

		try {
			Class<S> clientClass = config.getServiceClientClass(serviceClass);

			if (logger.isDebugEnabled())
				logger.debug("client class: " + clientClass.getName());

			S client = clientClass.newInstance();

			clientClass
					.getMethod("setWebService", new Class[] { Object.class })
					.invoke(client, endpoint);

			return client;
		} catch (InstantiationException e) {
			logger.error("Error creating service client", e);
		} catch (IllegalAccessException e) {
			logger.error("Error creating service client", e);
		} catch (IllegalArgumentException e) {
			logger.error("Error creating service client", e);
		} catch (SecurityException e) {
			logger.error("Error creating service client", e);
		} catch (InvocationTargetException e) {
			logger.error("Error creating service client", e);
		} catch (NoSuchMethodException e) {
			logger.error("Error creating service client", e);
		}

		return null;
	}

	public CompatibilityTransportConfiguration getConfig() {
		return config;
	}

	public void setConfig(CompatibilityTransportConfiguration config) {
		this.config = config;
	}

	public Class<S> getServiceClass() {
		return serviceClass;
	}

	public void setServiceClass(Class<S> serviceClass) {
		this.serviceClass = serviceClass;
	}
}