package eu.dnetlib.clients.utils.ws;

//import deltix.qsrv.comm.xml.ThrowableTransientAnnotationReaderBuilder;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.api.enabling.A2Service;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import eu.dnetlib.utils.resolver.TransportConfiguration;
import gr.uoa.di.driver.util.FallBackServiceLocator;
import gr.uoa.di.driver.util.RefreshingServiceLocator;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.util.ServiceLocatorFactory;
import org.apache.log4j.Logger;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

/**
 * This is an implementation of ServiceLocatorFactory for web service transport
 * layer. This implementation assumes that all service interfaces are part of
 * the DriverService hierarchy, but does not require that the web service
 * interfaces belong to the DriverWebService hierarchy.
 * 
 * This implementation is created for dnet45, where there is no common API for
 * all partners and the only transport layer is SOAP based for all services.
 * 
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 * 
 */
public class CompatibilityServiceLocatorFactory implements
		ServiceLocatorFactory {
	private static Logger logger = Logger.getLogger(CompatibilityServiceLocatorFactory.class);
	
	private TransportConfiguration configuration = null;
	private Map<Class<?>, ServiceClientFactory<?>> clientMap = null;
	private CompatibilityEndpointResolver endpointResolver = null;
	private StandaloneCxfEndpointReferenceBuilder eprBuilder = null;
	private ServiceNameResolver serviceNameResolver = null;
	private ServiceResolver serviceResolver = null;
	private ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
	private long locatorRefreshPeriod = 5*60*1000; // 5 minutes

	private UniqueServiceLocator serviceLocator = null;

	public void init() {
		logger.debug("Init...");
	}
	@Override
	public <S extends DriverService> ServiceLocator<S> newServiceLocator(
			Class<S> serviceClass) {
		if (serviceClass.equals(A2Service.class))
			throw new IllegalArgumentException("Cannot create " +
				"dynamic locator for A2Service");

		return newRefreshingServiceLocator(newDynamicServiceLocator(serviceClass));
	}

	@Override
	@SuppressWarnings("unchecked")
	public <S extends DriverService> ServiceLocator<S> newServiceLocator(
			Class<S> serviceClass, String serviceUrl) {

//		if (serviceClass.equals(A2Service.class))
//			return (ServiceLocator<S>) newA2ServiceLocator(serviceUrl);
//		else 
//		if (serviceClass.equals(StoreService.class))
//			return (ServiceLocator<S>) newStoreServiceClient(serviceUrl);
//		else
			return new FallBackServiceLocator<S>(
				newRefreshingServiceLocator(newDynamicServiceLocator(serviceClass)),
				newUrlServiceLocator(serviceClass, serviceUrl));
	}
	
	private <S extends DriverService> ServiceLocator<S> newRefreshingServiceLocator(
			ServiceLocator<S> locator) {
		RefreshingServiceLocator<S> rLocator = new RefreshingServiceLocator<S>();
		
		rLocator.setExecutor(executor);
		rLocator.setLocator(locator);
		rLocator.setPeriod(this.locatorRefreshPeriod);
		
		return rLocator;
	}

	private <S extends DriverService> ServiceLocator<S> newUrlServiceLocator(
			Class<S> serviceClass, String serviceUrl) {
		JaxwsServiceLocator<S> locator = new JaxwsServiceLocator<S>();
		
		locator.setEprBuilder(eprBuilder);
		locator.setServiceClass(serviceClass);
		locator.setUrl(serviceUrl);
		locator.setResolver(endpointResolver);
		
		return locator;
	}

	@SuppressWarnings("unchecked")
	private <S extends DriverService> ServiceLocator<S> newDynamicServiceLocator(
			Class<S> serviceClass) {
		CompatibilityServiceLocator<S> locator = new CompatibilityServiceLocator<S>();
		ServiceClientFactory<S> clientFactory = (ServiceClientFactory<S>) clientMap.get(serviceClass);

		locator.setClientFactory(clientFactory);
		locator.setServiceClass(serviceClass);
		locator.setServiceLocator(this.serviceLocator);

		return locator;
	}

	public StandaloneCxfEndpointReferenceBuilder getEprBuilder() {
		return eprBuilder;
	}

	public void setEprBuilder(StandaloneCxfEndpointReferenceBuilder eprBuilder) {
		this.eprBuilder = eprBuilder;
	}


	public ServiceNameResolver getServiceNameResolver() {
		return serviceNameResolver;
	}

	public void setServiceNameResolver(ServiceNameResolver serviceNameResolver) {
		this.serviceNameResolver = serviceNameResolver;
	}

	public ServiceResolver getServiceResolver() {
		return serviceResolver;
	}

	public void setServiceResolver(ServiceResolver serviceResolver) {
		this.serviceResolver = serviceResolver;
	}

	public TransportConfiguration getConfiguration() {
		return configuration;
	}

	public void setConfiguration(TransportConfiguration configuration) {
		this.configuration = configuration;
	}

	public CompatibilityEndpointResolver getEndpointResolver() {
		return endpointResolver;
	}

	public void setEndpointResolver(CompatibilityEndpointResolver endpointResolver) {
		this.endpointResolver = endpointResolver;
	}

	public Map<Class<?>, ServiceClientFactory<?>> getClientMap() {
		return clientMap;
	}

	public void setClientMap(Map<Class<?>, ServiceClientFactory<?>> clientMap) {
		this.clientMap = clientMap;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}
}
