package eu.dnetlib.clients.enabling.issn.ws;

import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ISSNService;
import eu.dnetlib.api.enabling.ISSNServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.enabling.is.sn.rmi.ISSNException;
import eu.dnetlib.utils.EPRUtils;

public class ISSNClient implements ISSNService {
	private eu.dnetlib.enabling.is.sn.rmi.ISSNService service = null;

	private static Logger logger = Logger.getLogger(ISSNClient.class);
	
	public void setPortType(eu.dnetlib.enabling.is.sn.rmi.ISSNService portType) {
		this.service = portType;
	}
	
	public void setWebService(Object webService) {
		this.service = (eu.dnetlib.enabling.is.sn.rmi.ISSNService) webService;
	}

	@Override
	public boolean actionCreatePerformed(String resourceType, String profileId,
			String profile) throws ISSNServiceException {
		try {
			return service.actionCreatePerformed(resourceType, profileId, profile);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("actionCreatePerformed error", e);
			
			throw new ISSNServiceException("actionCreatePerformed error");
		}
	}

	@Override
	public boolean actionDeletePerformed(String resourceType, String profileId)
			throws ISSNServiceException {
		try {
			return service.actionDeletePerformed(resourceType, profileId);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("actionDeletePerformed error", e);
			
			throw new ISSNServiceException("actionDeletePerformed error");
		}
	}

	@Override
	public boolean actionUpdatePerformed(String resourceType, String profileId,
			String profileBefore, String profileAfter)
			throws ISSNServiceException {
		try {
			return service.actionUpdatePerformed(resourceType, profileId, profileBefore, profileAfter);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("actionUpdatePerformed error", e);
			
			throw new ISSNServiceException("actionUpdatePerformed error");
		}
	}

	@Override
	public String getCurrentMessage(String topic) throws ISSNServiceException {
		try {
			return service.getCurrentMessage(topic);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("getCurrentMessage error", e);
			
			throw new ISSNServiceException("getCurrentMessage error");
		}
	}

	@Override
	public List<String> listSubscriptions() {
		return service.listSubscriptions();
	}

	@Override
	public boolean pauseSubscription(String subscrId)
			throws ISSNServiceException {
		try {
			return service.pauseSubscription(subscrId);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("Error pausing subscription", e);
			
			throw new ISSNServiceException("Error pausing subscription");
		}
	}

	@Override
	public boolean renew(String subscrId, int terminationTime)
			throws ISSNServiceException {
		try {
			return service.renew(subscrId, terminationTime);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("Error renewing subscription", e);
			
			throw new ISSNServiceException("Error renewing subscription");
		}
	}

	@Override
	public boolean resumeSubscription(String subscrId)
			throws ISSNServiceException {
		try {
			return service.resumeSubscription(subscrId);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("Error resuming subscription", e);
			
			throw new ISSNServiceException("Error resuming subscription");
		}
	}

	@Override
	public String subscribe(EPR consumerReference,
			String topicExpression, int initialTerminationTime)
			throws ISSNServiceException {
		try {
			W3CEndpointReference w3cEpr = EPRUtils.createW3CEPR(consumerReference);

			return service.subscribe(w3cEpr, topicExpression, initialTerminationTime);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("Error subscribing", e);
			
			throw new ISSNServiceException("Error subscribing");
		}
	}

	@Override
	public boolean unsubscribe(String subscrId) throws ISSNServiceException {
		try {
			return service.unsubscribe(subscrId);
		} catch (ISSNException e) {
			throw new ISSNServiceException(e);
		} catch (Exception e) {
			logger.error("Error unsubscribing", e);
			
			throw new ISSNServiceException("Error unsubscribing");
		}
	}

	@Override
	public ServiceIdentity identify() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void notify(Notification notification) {
		// TODO Auto-generated method stub
		throw new UnsupportedOperationException();		
	}
}