package eu.dnetlib.clients.data.search.ws;

import java.util.Collection;

import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.data.FormattedSearchResult;
import eu.dnetlib.domain.data.SearchResult;
import eu.dnetlib.domain.data.SuggestiveResult;

public class SearchWebServiceClient 
		extends	BaseWebServiceClient<SearchWebService> 
		implements SearchService {

	@Override
	public SuggestiveResult suggestiveSearch(String query)
			throws SearchServiceException {
		try {
			return webService.suggestiveSearch(query).toSuggestiveResult();
		} catch (Exception e) {
			throw new SearchServiceException("Error in suggestion.", e);
		}
		
	}

	@Override
	public SearchResult search(String queryText, String transformer,
			String locale, int page, int size) throws SearchServiceException {		
		try {
			return webService.search(queryText, transformer, locale, page, size);
		
		} catch (Exception e) {
			throw new SearchServiceException("Error in search.", e);
		}
	}

	@Override
	public SearchResult refine(String queryText, String transformer, 
			String locale, Collection<String> fields) throws SearchServiceException {
		try {
			return webService.refine(queryText, transformer, locale, fields);
		
		} catch (Exception e) {
			throw new SearchServiceException("Error in refine.", e);
		}
	}

	@Override
	public SearchResult searchNrefine(String queryText, String searchTransformer, String refineTransformer,
			String locale, int page, int size, Collection<String> fields) throws SearchServiceException {
		try {
			return webService.
				searchNrefine(queryText, searchTransformer, refineTransformer, locale, page, size, fields);
			
		} catch (Exception e){
			throw new SearchServiceException("Error in searchNrefine.", e);
		}
	}

	@Override
	public FormattedSearchResult search(String queryText, String transformer,
			String format, String locale, int page, int size)
			throws SearchServiceException {
		try {
			FormattedSearchResult fsr = webService.search(queryText, transformer, format, locale, page, size);
			
			if (fsr == null)
				throw new Exception("FSR is null!!!");
			
			return fsr;
			
		} catch (Exception e) {
			throw new SearchServiceException("Error in search.", e);
		}
	}

	@Override
	public FormattedSearchResult refine(String queryText, String refineTransformer, String format, String locale, Collection<String> fields) throws SearchServiceException {
		try {
			return webService.refine(queryText, refineTransformer, format, locale, fields);
			
		} catch (Exception e) {
			throw new SearchServiceException("Error in refine.", e);
		}
	}

	@Override
	public FormattedSearchResult searchNrefine(String queryText, String searchTransformer, String refineTransformer, 
			String format, String locale, int page, int size, Collection<String> fields)
			throws SearchServiceException {
		try {
			return webService.searchNrefine(queryText, searchTransformer, refineTransformer, format, locale, page, size, fields);
			
		} catch (Exception e){
			throw new SearchServiceException("Error in searchNrefine.", e);
		}
	}
}
