package eu.dnetlib.clients.utils.ws;

import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;

public class CompatibilityServiceNameResolver implements ServiceNameResolver {
	private static Logger logger = Logger.getLogger(CompatibilityServiceNameResolver.class);
	private Map<Class<?>, String> override = null;
	private CompatibilityTransportConfiguration config = null;

	@Override
	public String getName(Object service) {
		return getName(service.getClass());
	}

	@Override
	public String getName(Class<?> serviceInterface) {
		String serviceName = null;

		logger.debug("Looking for name of service " + serviceInterface.getName());

		if (override.get(serviceInterface) != null) {
			serviceName = override.get(serviceInterface);
		} else {
			serviceName = config.getServiceClass(serviceInterface).getSimpleName();
		}

		logger.debug("Service name for class: " + serviceInterface.getName()
				+ " is " + serviceName);

		return serviceName;

	}

	public Map<Class<?>, String> getOverride() {
		return override;
	}

	public void setOverride(Map<Class<?>, String> override) {
		this.override = override;
	}

	public CompatibilityTransportConfiguration getConfig() {
		return config;
	}

	public void setConfig(CompatibilityTransportConfiguration config) {
		this.config = config;
	}

}
