package eu.dnetlib.clients.functionality.rating.ws;

import java.util.List;

import javax.jws.WebService;

import eu.dnetlib.api.functionality.RatingService;
import eu.dnetlib.api.functionality.RatingServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.Rating;

/**
 * This class implements rating web service using a rating service.
 * @author thanos@di.uoa.gr
 *
 */
@WebService(
		serviceName = "RatingWebService", 
		endpointInterface = "eu.dnetlib.clients.functionality.rating.ws.RatingWebService")
public class RatingWebServiceImpl
		extends BaseDriverWebService<RatingService>
		implements RatingWebService {
	
	@Override
	public List<Rating> getTopDocuments(int limit) throws RatingWebServiceException {
		try {
			return service.getTopDocuments(limit);
		} catch (RatingServiceException e) {
			throw new RatingWebServiceException(e);
		}
	}

	@Override
	public List<Rating> getTopRatings(int limit) throws RatingWebServiceException {
		try {
			return service.getTopRatings(limit);
		} catch (RatingServiceException e) {
			throw new RatingWebServiceException(e);
		}
	}

	@Override
	public void rate(String userId, String documentId, float score) throws RatingWebServiceException {
		try {
			service.rate(userId, documentId, score);
		} catch (RatingServiceException e) {
			throw new RatingWebServiceException(e);
		}
	}

	@Override
	public List<Rating> searchRatingsByDocument(String documentId) throws RatingWebServiceException {
		try {
			return service.searchRatingsByDocument(documentId);
		} catch (RatingServiceException e) {
			throw new RatingWebServiceException(e);
		}
	}

	@Override
	public List<Rating> searchRatingsByUser(String userId) throws RatingWebServiceException {
		try {
			return service.searchRatingsByUser(userId);
		} catch (RatingServiceException e) {
			throw new RatingWebServiceException(e);
		}
	}
}
