package eu.dnetlib.clients.functionality.recommendation.ws;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

import eu.dnetlib.api.functionality.RecommendationService;
import eu.dnetlib.api.functionality.RecommendationServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.Recommendation;

public class RecommendationWebServiceClient extends
		BaseWebServiceClient<RecommendationWebService> implements
		RecommendationService {

	@Override
	public String generateAnnouncement(int index, boolean active,
			String announcementTitle, String announcementText,
			Date creationDate, Date expirationDate)
			throws RecommendationServiceException {
		try {
			return this.webService.generateAnnouncement(index, active,
					announcementTitle, announcementText, creationDate,
					expirationDate);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}

	}

	@Override
	public String generateCommunityRecommendation(int index, boolean active,
			String title, String recommendationText, Date creationDate,
			Date expirationDate, Set<String> communityIds)
			throws RecommendationServiceException {
		try {
			return this.webService.generateCommunityRecommendation(index,
					active, title, recommendationText,
					creationDate, expirationDate, communityIds);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public Recommendation generateRecommendation(int index, boolean active,
			String title, String recommendationText, Date creationDate,
			Date expirationDate) throws RecommendationServiceException {
		try {
			return this.webService.generateRecommendation(index, active,
					title, recommendationText, creationDate,
					expirationDate);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public List<String> getAllAnnouncementIds()
			throws RecommendationServiceException {
		List<String> tmp = this.webService.getAllAnnouncementIds();
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public List<Recommendation> getAllAnnouncements()
			throws RecommendationServiceException {
		List<Recommendation> tmp = this.webService.getAllAnnouncements();
		if (tmp == null)
			return new ArrayList<Recommendation>();
		else
			return tmp;
	}

	@Override
	public List<String> getAllCommunityRecommendations()
			throws RecommendationServiceException {
		List<String> tmp = this.webService.getAllCommunityRecommendations();
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public List<Recommendation> getAllCommunityRecommendationsObj()
			throws RecommendationServiceException {
		List<Recommendation> tmp = this.webService
				.getAllCommunityRecommendationsObj();
		if (tmp == null)
			return new ArrayList<Recommendation>();
		else
			return tmp;
	}

	@Override
	public List<String> getAllCommunityRecommendations(String communityId)
			throws RecommendationServiceException {
		List<String> tmp = this.webService
				.getAllCommunityRecommendations(communityId);
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public List<Recommendation> getAllCommunityRecommendationsObj(
			String communityId) throws RecommendationServiceException {
		List<Recommendation> tmp = this.webService
				.getAllCommunityRecommendationsObj(communityId);
		if (tmp == null)
			return new ArrayList<Recommendation>();
		else
			return tmp;
	}

	@Override
	public List<String> getAllUserRecommendations(String userId)
			throws RecommendationServiceException {
		List<String> tmp = this.webService.getAllUserRecommendations(userId);
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public List<String> getAnnouncements()
			throws RecommendationServiceException {
		List<String> tmp = this.webService.getAnnouncements();
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public List<String> getCommunityRecommendations(String communityId)
			throws RecommendationServiceException {
		List<String> tmp = this.webService
				.getCommunityRecommendations(communityId);
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public List<Recommendation> getCommunityRecommendationsObj(
			String communityId) throws RecommendationServiceException {
		List<Recommendation> tmp = this.webService
				.getCommunityRecommendationsObj(communityId);
		if (tmp == null)
			return new ArrayList<Recommendation>();
		else
			return tmp;
	}

	@Override
	public List<String> getCommunityRecommendationsForUser(String userId)
			throws RecommendationServiceException {
		List<String> tmp = this.webService
				.getCommunityRecommendationsForUser(userId);
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public List<Recommendation> getCommunityRecommendationsForUserObj(
			String userId) throws RecommendationServiceException {
		List<Recommendation> tmp = this.webService
				.getCommunityRecommendationsForUserObj(userId);
		if (tmp == null)
			return new ArrayList<Recommendation>();
		else
			return tmp;
	}

	@Override
	public Recommendation getRecommendation(String recommendationId)
			throws RecommendationServiceException {
		return this.webService.getRecommendation(recommendationId);
	}

	@Override
	public String getRecommendationText(String recommendationId)
			throws RecommendationServiceException {
		return this.webService.getRecommendationText(recommendationId);
	}

	@Override
	public List<String> getRecommendations(List<String> recommendationIds)
			throws RecommendationServiceException {
		List<String> tmp = this.webService
				.getRecommendations(recommendationIds);
		if (tmp == null)
			return new ArrayList<String>();
		else
			return tmp;
	}

	@Override
	public void removeAnnouncement(String announcementId)
			throws RecommendationServiceException {
		try {
			this.webService.removeAnnouncement(announcementId);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void removeCommunityRecommendation(String recommendationId)
			throws RecommendationServiceException {
		try {
			this.webService.removeCommunityRecommendation(recommendationId);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void removeRecommendation(String recommendationId)
			throws RecommendationServiceException {
		try {
			this.webService.removeRecommendation(recommendationId);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void removeUserRecommendation(String recommendationId)
			throws RecommendationServiceException {
		try {
			this.webService.removeUserRecommendation(recommendationId);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void updateAnnouncement(String announcementId, int index,
			boolean active, String announcementTitle, String announcementText,
			Date creationDate, Date expirationDate)
			throws RecommendationServiceException {
		try {
			this.webService.updateAnnouncement(announcementId, index, active,
					announcementTitle, announcementText, creationDate,
					expirationDate);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void updateCommunityRecommendation(String recommendationId,
			int index, boolean active, String title, String recommendationText,
			Date creationDate, Date expirationDate, Set<String> communityIds)
			throws RecommendationServiceException {
		try {
			this.webService.updateCommunityRecommendation(recommendationId,
					index, active, title, recommendationText,
					creationDate, expirationDate, communityIds);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void updateRecommendation(String recommendationId, int index,
			boolean active, String title, String recommendationText,
			Date creationDate, Date expirationDate)
			throws RecommendationServiceException {
		// TODO Auto-generated method stub
		try {
			this.webService.updateRecommendation(recommendationId, index,
					active, title, recommendationText,
					creationDate, expirationDate);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void addRecommendationToUser(String recommendationId, String userId)
			throws RecommendationServiceException {
		try {
			this.webService.addRecommendationToUser(recommendationId, userId);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public String generateUserRecommendation(int index, boolean active,
			String title, String userId, String recommendationText,
			Date creationDate, Date expirationDate)
			throws RecommendationServiceException {
		try {
			return this.webService.generateUserRecommendation(index, active,
					userId, title, recommendationText,
					creationDate, expirationDate);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	@Override
	public void swapAnnouncements(String announcementId1, String announcementId2)
			throws RecommendationServiceException {
		try {
			this.webService.swapAnnouncements(announcementId1, announcementId2);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	public void swapCommunityRecommendations(String recommendationId1,
			String recommendationId2) throws RecommendationServiceException {
		try {
			this.webService.swapAnnouncements(recommendationId1, recommendationId2);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

	public void swapUserRecommendations(String recommendationId1,
			String recommendationId2) throws RecommendationServiceException {
		try {
			this.webService.swapAnnouncements(recommendationId1, recommendationId2);
		} catch (RecommendationWebServiceException e) {
			throw new RecommendationServiceException(e);
		}
	}

}
