package eu.dnetlib.clients.utils.ws;

import eu.dnetlib.common.rmi.BaseService;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.utils.resolver.TransportConfiguration;
import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import gr.uoa.di.driver.util.ServiceLocator;

/**
 * This is an implementation of the service locator that uses a CNR service
 * locator. The CNR service locator returns endpoints to services, so the job of
 * this locator is to use the CNR locator to get service endpoint and use a
 * ServiceClientFactory to create a client for this endpoint.
 * 
 * It holds no cache of the located service. Any subsequent call to getService()
 * will produce a new client. It is up to the caller to cache and refresh the
 * result.
 * 
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 * 
 * @param <S>
 */
public class CompatibilityServiceLocator<S extends DriverService> implements
		ServiceLocator<S> {

	private static Logger logger = Logger.getLogger(CompatibilityServiceLocator.class);

	private UniqueServiceLocator serviceLocator;

	/** The service class */
	private Class<S> serviceClass = null;

	TransportConfiguration transportConfiguration = null;

	/** The factory used to create service clients */
	private ServiceClientFactory<S> clientFactory = null;

	@Override
	public S getService() {
		logger.debug("Locating service of type : "
				+ this.serviceClass.getName());
		S service = null;

		try {
			Class<? extends BaseService> endpointClass =  (Class<? extends BaseService>) transportConfiguration.getEndpointClass(serviceClass);

			Object endpoint = serviceLocator.getService(endpointClass);

			logger.debug("Found service endpoint of type: "
					+ endpoint.getClass().getName());

			service = clientFactory.newClient(endpoint);
		} catch (Exception e) {
			logger.debug("Failed to find service", e);
		}

		return service;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public Class<S> getServiceClass() {
		return serviceClass;
	}

	public void setServiceClass(Class<S> serviceClass) {
		this.serviceClass = serviceClass;
	}

	public void setClientFactory(ServiceClientFactory<S> clientFactory) {
		this.clientFactory = clientFactory;
	}

	public TransportConfiguration getTransportConfiguration() {
		return transportConfiguration;
	}

	public void setTransportConfiguration(TransportConfiguration transportConfiguration) {
		this.transportConfiguration = transportConfiguration;
	}
}