package eu.dnetlib.clients.ws;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;

public abstract class BaseDriverWebService<S extends DriverService> implements
		DriverWebService<S> {
	private static Logger logger = Logger.getLogger(BaseDriverWebService.class);

	protected S service = null;

	public void setService(S service) {
		this.service = service;
	}

	@Override
	public final String identify() {
		ServiceIdentity identity = service.identify();
		
		if (identity != null)
			return service.identify().toString();
		else
			return null;
	}

	@Override
	public final void notify(String subscriptionId, String topic, String isId,
			String message) {
		logger.debug("Notification received: " + topic + ", message: "
				+ message);

		try {
			Notification notification = new Notification(subscriptionId,
					message, topic, isId);

			service.notify(notification);
		} catch (Exception e) {
			logger.error("Error creating notification", e);
		}
	}

	@Override
	public void start() {
		throw new UnsupportedOperationException();
	}

}
