package eu.dnetlib.clients.functionality.community.ws;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.jws.WebService;

import eu.dnetlib.api.functionality.CommunityService;
import eu.dnetlib.api.functionality.CommunityServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.Community;
import eu.dnetlib.domain.functionality.CommunitySearchCriteria;

/**
 * This class implements a community web service using a community service.
 * @author thanos
 *
 */
@WebService(
		serviceName = "CommunityWebService", 
		endpointInterface = "eu.dnetlib.clients.functionality.community.ws.CommunityWebService")
public class CommunityWebServiceImpl
		extends BaseDriverWebService<CommunityService>
		implements CommunityWebService {
	
	@Override
	public void addCollection(String communityId, String collectionId)
			throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getCollections().add(collectionId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void addManager(String communityId, String userId)
			throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getManagers().add(userId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void addRecommendation(String communityId, String recommendationId)
			throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getRecommendations().add(recommendationId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public String createCommunity(String name, String ownerId)
			throws CommunityWebServiceException {
		try {
			Community community = new Community();
			community.setName(name);
			community.setOwner(ownerId);
			return service.saveCommunity(community).getResourceId();
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public List<String> getAllCommunityIds() throws CommunityWebServiceException {
		return searchCommunityIds(new CommunitySearchCriteria());
	}

	@Override
	public Set<String> getCollections(String communityId)
			throws CommunityWebServiceException {
		try {
			return service.getCommunityById(communityId).getCollections();
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public Community getCommunity(String id)
			throws CommunityWebServiceException {
		try {
			return service.getCommunityById(id);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public Set<String> getManagers(String communityId)
			throws CommunityWebServiceException {
		try {
			return service.getCommunityById(communityId).getManagers();
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public Set<String> getRecommendations(String communityId)
			throws CommunityWebServiceException {
		try {
			return service.getCommunityById(communityId).getRecommendations();
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void removeCollection(String communityId, String collectionId)
			throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getCollections().remove(collectionId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void removeCommunity(String id) throws CommunityWebServiceException {
		try {
			service.deleteCommunityById(id);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void removeManager(String communityId, String userId)
			throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getManagers().remove(userId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void removeRecommendation(String communityId, String recommendationId)
			throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getRecommendations().remove(recommendationId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void updateCommunity(String id, String name, String description,
			String owner, Set<String> managers, Set<String> collections,
			Set<String> recommendations, Set<String> authoritativeDocuments) throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(id);
			community.setName(name);
			community.setDescription(description);
			community.setOwner(owner);
			community.setManagers(managers == null ? new HashSet<String>() : managers);
			community.setCollections(collections == null ? new HashSet<String>() : collections);
			community.setRecommendations(recommendations == null ? new HashSet<String>() : recommendations);
			community.setAuthoritativeDocuments(authoritativeDocuments == null ? new HashSet<String>() : authoritativeDocuments);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public List<Community> searchCommunities(CommunitySearchCriteria criteria)
			throws CommunityWebServiceException {
		try {
			return service.searchCommunities(criteria);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public List<String> searchCommunityIds(CommunitySearchCriteria criteria)
			throws CommunityWebServiceException {
		try {
			return service.searchCommunityIds(criteria);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void addAuthoritativeDocument(String communityId, String documentId) throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getAuthoritativeDocuments().add(documentId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public Set<String> getAuthoritativeDocuments(String communityId) throws CommunityWebServiceException {
		try {
			return service.getCommunityById(communityId).getAuthoritativeDocuments();
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e);
		}
	}

	@Override
	public void removeAuthoritativeDocument(String communityId, String documentId) throws CommunityWebServiceException {
		try {
			Community community = service.getCommunityById(communityId);
			community.getAuthoritativeDocuments().remove(documentId);
			service.saveCommunity(community);
		} catch (CommunityServiceException e) {
			throw new CommunityWebServiceException(e); 
		}
	}
}
