/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.functionality.community.ws;

import eu.dnetlib.api.functionality.CommunityService;
import eu.dnetlib.api.functionality.CommunityServiceException;
import eu.dnetlib.clients.functionality.community.ws.CommunityWebService;
import eu.dnetlib.clients.functionality.community.ws.CommunityWebServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.Community;
import eu.dnetlib.domain.functionality.CommunitySearchCriteria;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommunityWebServiceClient
extends BaseWebServiceClient<CommunityWebService>
implements CommunityService {
    public void deleteCommunity(Community community) throws CommunityServiceException {
        try {
            ((CommunityWebService)this.webService).removeCommunity(community.getResourceId());
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }

    public void deleteCommunityById(String id) throws CommunityServiceException {
        try {
            ((CommunityWebService)this.webService).removeCommunity(id);
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }

    public Community getCommunityById(String id) throws CommunityServiceException {
        try {
            Community community = ((CommunityWebService)this.webService).getCommunity(id);
            if (community.getManagers() == null) {
                community.setManagers(new HashSet());
            }
            if (community.getCollections() == null) {
                community.setCollections(new HashSet());
            }
            if (community.getRecommendations() == null) {
                community.setRecommendations(new HashSet());
            }
            if (community.getAuthoritativeDocuments() == null) {
                community.setAuthoritativeDocuments(new HashSet());
            }
            return community;
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }

    public boolean isManager(String communityId, String userId) throws CommunityServiceException {
        try {
            Set<String> managers = ((CommunityWebService)this.webService).getManagers(communityId);
            if (managers == null) {
                managers = new HashSet<String>();
            }
            return managers.contains(userId);
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }

    public boolean isOwner(String communityId, String userId) throws CommunityServiceException {
        try {
            return ((CommunityWebService)this.webService).getCommunity(communityId).getOwner().equals(userId);
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }

    public Community saveCommunity(Community community) throws CommunityServiceException {
        try {
            if (community.getResourceId() == null || ((CommunityWebService)this.webService).getCommunity(community.getResourceId()) == null) {
                community.setResourceId(((CommunityWebService)this.webService).createCommunity(community.getName(), community.getOwner()));
            }
            ((CommunityWebService)this.webService).updateCommunity(community.getResourceId(), community.getName(), community.getDescription(), community.getOwner(), community.getManagers(), community.getCollections(), community.getRecommendations(), community.getAuthoritativeDocuments());
            return community;
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }

    public List<Community> searchCommunities(CommunitySearchCriteria criteria) throws CommunityServiceException {
        try {
            List<Community> communities = ((CommunityWebService)this.webService).searchCommunities(criteria);
            if (communities == null) {
                communities = new ArrayList<Community>();
            }
            for (Community community : communities) {
                if (community.getManagers() == null) {
                    community.setManagers(new HashSet());
                }
                if (community.getCollections() == null) {
                    community.setCollections(new HashSet());
                }
                if (community.getRecommendations() == null) {
                    community.setRecommendations(new HashSet());
                }
                if (community.getAuthoritativeDocuments() != null) continue;
                community.setAuthoritativeDocuments(new HashSet());
            }
            return communities;
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }

    public List<String> searchCommunityIds(CommunitySearchCriteria criteria) throws CommunityServiceException {
        try {
            ArrayList communityIds = ((CommunityWebService)this.webService).searchCommunityIds(criteria);
            return communityIds == null ? new ArrayList() : communityIds;
        }
        catch (CommunityWebServiceException e) {
            throw new CommunityServiceException((Throwable)e);
        }
    }
}

