package eu.dnetlib.clients.functionality.profile.ws;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import eu.dnetlib.api.functionality.UserProfileService;
import eu.dnetlib.api.functionality.UserProfileServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.domain.functionality.UserProfileSearchCriteria;

public class UserProfileWebServiceClient
		extends BaseWebServiceClient<UserProfileWebService>
		implements UserProfileService {
	
	private static Logger logger = Logger.getLogger(UserProfileWebServiceClient.class);
	
	@Override
	public void deleteUser(UserProfile profile)
			throws UserProfileServiceException {
		try {
			webService.deleteUserById(profile.getResourceId());
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public void deleteUserById(String id) throws UserProfileServiceException {
		try {
			webService.deleteUserById(id);
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public UserProfile getUserById(String id)
			throws UserProfileServiceException {
		try {
			return webService.getUserById(id);
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public UserProfile saveUser(UserProfile profile)
			throws UserProfileServiceException {
		try {
			return webService.saveUser(profile);
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public List<String> searchUserIds(UserProfileSearchCriteria criteria)
			throws UserProfileServiceException {
		try {
			List<String> ids = webService.searchUserIds(criteria);
			
			if (ids == null) {
				logger.debug("Id list is null while it shouldn't be.");
				ids = new ArrayList<String>();
			}
			
			return ids;
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		}
	}

	@Override
	public List<UserProfile> searchUsers(UserProfileSearchCriteria criteria)
			throws UserProfileServiceException {
		try {
			List<UserProfile> profiles = webService.searchUsers(criteria);

			if (profiles == null) {
				logger.debug("profile list is null while it shouldn't be.");
				profiles = new ArrayList<UserProfile>();
			}

			return profiles;			
		} catch (UserProfileWebServiceException e) {
			throw new UserProfileServiceException(e);
		} 
	}
}
