package eu.dnetlib.clients.functionality.community.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import eu.dnetlib.api.functionality.CommunityService;
import eu.dnetlib.api.functionality.CommunityServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.Community;
import eu.dnetlib.domain.functionality.CommunitySearchCriteria;

/**
 * This class implements community service using a community web service.
 * @author thanos
 *
 */
public class CommunityWebServiceClient
		extends BaseWebServiceClient<CommunityWebService>
		implements CommunityService {
	
	@Override
	public void deleteCommunity(Community community)
			throws CommunityServiceException {
		try {
			webService.removeCommunity(community.getResourceId());
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}

	@Override
	public void deleteCommunityById(String id) throws CommunityServiceException {
		try {
			webService.removeCommunity(id);
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}

	@Override
	public Community getCommunityById(String id)
			throws CommunityServiceException {
		try {
			Community community = webService.getCommunity(id);
			if(community.getManagers() == null)
				community.setManagers(new HashSet<String>());
			if (community.getCollections() == null)
				community.setCollections(new HashSet<String>());
			if (community.getRecommendations() == null)
				community.setRecommendations(new HashSet<String>());
			if (community.getAuthoritativeDocuments() == null)
				community.setAuthoritativeDocuments(new HashSet<String>());
			return community;
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}

	@Override
	public boolean isManager(String communityId, String userId)
			throws CommunityServiceException {
		try {
			Set<String> managers = webService.getManagers(communityId);
			if (managers == null)
				managers = new HashSet<String>();
			return managers.contains(userId);
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}

	@Override
	public boolean isOwner(String communityId, String userId)
			throws CommunityServiceException {
		try {
			return webService.getCommunity(communityId).getOwner().equals(userId);
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}

	@Override
	public Community saveCommunity(Community community)
			throws CommunityServiceException {
		try {
			// community does not exist; create it
			if (community.getResourceId() == null || webService.getCommunity(community.getResourceId()) == null)
				community.setResourceId(webService.createCommunity(community.getName(), community.getOwner()));
			// update the rest fields
			webService.updateCommunity(community.getResourceId(), community.getName(), community.getDescription(), community.getOwner(), community.getManagers(), community.getCollections(), community.getRecommendations(), community.getAuthoritativeDocuments());
			return community;
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}

	@Override
	public List<Community> searchCommunities(CommunitySearchCriteria criteria)
			throws CommunityServiceException {
		try {
			List<Community> communities = webService.searchCommunities(criteria);
			if (communities == null)
				communities = new ArrayList<Community>();
			for (Community community : communities) {
				if(community.getManagers() == null)
					community.setManagers(new HashSet<String>());
				if (community.getCollections() == null)
					community.setCollections(new HashSet<String>());
				if (community.getRecommendations() == null)
					community.setRecommendations(new HashSet<String>());
				if (community.getAuthoritativeDocuments() == null)
					community.setAuthoritativeDocuments(new HashSet<String>());
			}
			return communities;
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}

	@Override
	public List<String> searchCommunityIds(CommunitySearchCriteria criteria)
			throws CommunityServiceException {
		try {
			List<String> communityIds = webService.searchCommunityIds(criteria);
			return (communityIds == null ? new ArrayList<String>() : communityIds);
		} catch (CommunityWebServiceException e) {
			throw new CommunityServiceException(e);
		}
	}
}
