/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.functionality.community.ws;

import eu.dnetlib.api.functionality.CommunityService;
import eu.dnetlib.api.functionality.CommunityServiceException;
import eu.dnetlib.clients.functionality.community.ws.CommunityWebService;
import eu.dnetlib.clients.functionality.community.ws.CommunityWebServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.Community;
import eu.dnetlib.domain.functionality.CommunitySearchCriteria;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;

@WebService(serviceName="CommunityWebService", endpointInterface="eu.dnetlib.clients.functionality.community.ws.CommunityWebService")
public class CommunityWebServiceImpl
extends BaseDriverWebService<CommunityService>
implements CommunityWebService {
    @Override
    public void addCollection(String communityId, String collectionId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getCollections().add(collectionId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void addManager(String communityId, String userId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getManagers().add(userId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void addRecommendation(String communityId, String recommendationId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getRecommendations().add(recommendationId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public String createCommunity(String name, String ownerId) throws CommunityWebServiceException {
        try {
            Community community = new Community();
            community.setName(name);
            community.setOwner(ownerId);
            return ((CommunityService)this.service).saveCommunity(community).getResourceId();
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public List<String> getAllCommunityIds() throws CommunityWebServiceException {
        return this.searchCommunityIds(new CommunitySearchCriteria());
    }

    @Override
    public Set<String> getCollections(String communityId) throws CommunityWebServiceException {
        try {
            return ((CommunityService)this.service).getCommunityById(communityId).getCollections();
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public Community getCommunity(String id) throws CommunityWebServiceException {
        try {
            return ((CommunityService)this.service).getCommunityById(id);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public Set<String> getManagers(String communityId) throws CommunityWebServiceException {
        try {
            return ((CommunityService)this.service).getCommunityById(communityId).getManagers();
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public Set<String> getRecommendations(String communityId) throws CommunityWebServiceException {
        try {
            return ((CommunityService)this.service).getCommunityById(communityId).getRecommendations();
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void removeCollection(String communityId, String collectionId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getCollections().remove(collectionId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void removeCommunity(String id) throws CommunityWebServiceException {
        try {
            ((CommunityService)this.service).deleteCommunityById(id);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void removeManager(String communityId, String userId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getManagers().remove(userId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void removeRecommendation(String communityId, String recommendationId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getRecommendations().remove(recommendationId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void updateCommunity(String id, String name, String description, String owner, Set<String> managers, Set<String> collections, Set<String> recommendations, Set<String> authoritativeDocuments) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(id);
            community.setName(name);
            community.setDescription(description);
            community.setOwner(owner);
            community.setManagers((Set)(managers == null ? new HashSet() : managers));
            community.setCollections((Set)(collections == null ? new HashSet() : collections));
            community.setRecommendations((Set)(recommendations == null ? new HashSet() : recommendations));
            community.setAuthoritativeDocuments((Set)(authoritativeDocuments == null ? new HashSet() : authoritativeDocuments));
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public List<Community> searchCommunities(CommunitySearchCriteria criteria) throws CommunityWebServiceException {
        try {
            return ((CommunityService)this.service).searchCommunities(criteria);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public List<String> searchCommunityIds(CommunitySearchCriteria criteria) throws CommunityWebServiceException {
        try {
            return ((CommunityService)this.service).searchCommunityIds(criteria);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void addAuthoritativeDocument(String communityId, String documentId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getAuthoritativeDocuments().add(documentId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public Set<String> getAuthoritativeDocuments(String communityId) throws CommunityWebServiceException {
        try {
            return ((CommunityService)this.service).getCommunityById(communityId).getAuthoritativeDocuments();
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }

    @Override
    public void removeAuthoritativeDocument(String communityId, String documentId) throws CommunityWebServiceException {
        try {
            Community community = ((CommunityService)this.service).getCommunityById(communityId);
            community.getAuthoritativeDocuments().remove(documentId);
            ((CommunityService)this.service).saveCommunity(community);
        }
        catch (CommunityServiceException e) {
            throw new CommunityWebServiceException(e);
        }
    }
}

