package eu.dnetlib.clients.functionality.validator.ws;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.JobResultEntry;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;

import javax.jws.WebService;
import java.util.List;

@WebService(
		targetNamespace ="http://services.dnetlib.eu/",
		serviceName = "ValidatorWebService", 
		endpointInterface = "eu.dnetlib.clients.functionality.validator.ws.ValidatorWebService")
public class ValidatorWebServiceImpl
		extends BaseDriverWebService<ValidatorService>
		implements ValidatorWebService {

	@Override
	public StoredJob getStoredJob(int jobId, String groupBy)
			throws ValidatorServiceException {
		return service.getStoredJob(jobId, groupBy);
	}

	@Override
	public List<StoredJob> getJobSummary(List<String> baseUrl, int limit) throws ValidatorServiceException {
		return service.getJobSummary(baseUrl,limit);
	}

	@Override
	public List<StoredJob> getStoredJobs(String userMail, String jobType,
			Integer offset, Integer limit, String dateFrom, String dateTo) throws ValidatorServiceException {
		return service.getStoredJobs(userMail, jobType, offset, limit, dateFrom, dateTo);
	}

	@Override
	public List<StoredJob> getStoredJobsNew(String userMail, String jobType,
										 Integer offset, Integer limit, String dateFrom, String dateTo, String jobStatus) throws ValidatorServiceException {
		return service.getStoredJobsNew(userMail, jobType, offset, limit, dateFrom, dateTo, jobStatus);
	}
	
	@Override
	public int getStoredJobsTotalNumber(String userMail, String jobType) throws ValidatorServiceException {
		return service.getStoredJobsTotalNumber(userMail, jobType);
	}

	@Override
	public int getStoredJobsTotalNumberNew(String userMail, String jobType, String jobStatus) throws ValidatorServiceException {
		return service.getStoredJobsTotalNumberNew(userMail, jobType, jobStatus);
	}

	@Override
	public List<RuleSet> getRuleSets() throws ValidatorServiceException {
		return service.getRuleSets();
	}

	@Override
	public void submitValidationJob(JobForValidation job)
			throws ValidatorServiceException {
		service.submitValidationJob(job);
	}





}
