package eu.dnetlib.clients.functionality.rating.ws;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.api.functionality.RatingService;
import eu.dnetlib.clients.ws.DriverWebService;
import eu.dnetlib.domain.functionality.Rating;

/**
 * This interface describes the available methods of a rating web service.
 * @author thanos@di.uoa.gr
 *
 */
@WebService
public interface RatingWebService extends DriverWebService<RatingService> {
	/**
	 * Rate a document by a specifed user.
	 * @param userId the id of the user
	 * @param documentId the id of the document
	 * @param score the rating score
	 * @throws RatingWebServiceException if any errors occur
	 */
	@WebMethod(operationName = "rate")
	public void rate(
			@WebParam(name = "userId") String userId,
			@WebParam(name = "documentId") String documentId,
			@WebParam(name = "score") float score
			) throws RatingWebServiceException;
	
	/**
	 * Search for existing ratings by user.
	 * @param userId the id of the user
	 * @return a list containing all the ratings of the specified user ordered by score
	 * @throws RatingWebServiceException if any errors occur
	 */
	@WebMethod(operationName = "searchRatingsByUser")
	public List<Rating> searchRatingsByUser(
			@WebParam(name = "userId") String userId
			) throws RatingWebServiceException;
	
	/**
	 * Search for existing ratings by document.
	 * @param documentId the id of the document
	 * @return a list containing all the ratings of the soecified document ordered by score
	 * @throws RatingWebServiceException if any errors occur
	 */
	@WebMethod(operationName = "searchRatingsByDocument")
	public List<Rating> searchRatingsByDocument(
			@WebParam(name = "documentId") String documentId
			) throws RatingWebServiceException;
	
	/**
	 * Get the top ratings.
	 * @param limit the maximum number of ratings to retrieve
	 * @return a list containing the top ratings ordered by score
	 * @throws RatingWebServiceException if any errors occur
	 */
	@WebMethod(operationName = "getTopRatings")
	public List<Rating> getTopRatings(
			@WebParam(name = "limit") int limit
			) throws RatingWebServiceException;
	
	/**
	 * Get the top documents.
	 * @param limit the maximum number of ratings to retrieve
	 * @return a list containing the top document average ratings ordered by score
	 * @throws RatingWebServiceException if any errors occur
	 */
	@WebMethod(operationName = "getTopDocuments")
	public List<Rating> getTopDocuments(
			@WebParam(name = "limit") int limit
			) throws RatingWebServiceException;
}