package eu.dnetlib.clients.data.search.ws;

import java.util.Collection;

import javax.jws.WebMethod;
import javax.jws.WebService;

import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.clients.ws.DriverWebService;
import eu.dnetlib.domain.data.FormattedSearchResult;
import eu.dnetlib.domain.data.SearchResult;

@WebService (targetNamespace ="http://services.dnetlib.eu/")
public interface SearchWebService extends DriverWebService<SearchService> {
	@WebMethod(operationName = "search")
	public SearchResult search(String queryText, String transformer,
			String locale, int page, int size) throws SearchWebServiceException;

	@WebMethod(operationName = "refine")
	public SearchResult refine(String queryText, String transformer,
			String locale, Collection<String> fields) throws SearchWebServiceException;

	@WebMethod(operationName = "searchNrefine")
	public SearchResult searchNrefine(String queryText, String searchTransformer, 
			String refineTransformer, String locale, int page, int size, Collection<String> fields)
				throws SearchWebServiceException;
	
	@WebMethod(operationName = "suggestiveSearch")
	public SuggestiveWebResult suggestiveSearch(String query) throws SearchWebServiceException;
	
	@WebMethod(operationName = "getSearchResult")
	public FormattedSearchResult search(String queryText, String transformer,
			String format, String locale, int page, int size) throws SearchWebServiceException;
	
	@WebMethod(operationName = "getRefineResult")	
	public FormattedSearchResult refine(String queryText, String refineTransformer, 
			String format, String locale, Collection<String> fields) 
				throws SearchWebServiceException;
	
	@WebMethod(operationName = "getSearchNRefineResult")	
	public FormattedSearchResult searchNrefine(String queryText, String searchTransformer, String refineTransformer, 
			String format, String locale, int page, int size, Collection<String> fields)
			throws SearchWebServiceException;
}
