package eu.dnetlib.clients.utils.ws;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.api.DriverServiceEndpoint;
import eu.dnetlib.utils.resolver.TransportConfiguration;

public class CompatibilityTransportConfiguration implements
		TransportConfiguration {
	static Logger logger = Logger
			.getLogger(CompatibilityTransportConfiguration.class);

	private Map<Class<? extends DriverService>, Class<?>> endpointMapping = null;
	private Map<Class<? extends DriverServiceEndpoint<?>>, Class<?>> serviceMapping = new HashMap<Class<? extends DriverServiceEndpoint<?>>, Class<?>>();
	private Map<Class<? extends DriverService>, Class<? extends DriverService>> clientMapping = null;

	@Override
	public <T extends DriverService> Class<?> getEndpointClass(
			Class<T> serviceClass) {
		return endpointMapping.get(serviceClass);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends DriverService> Class<T> getServiceClientClass(
			Class<T> serviceClass) {
		return (Class<T>) clientMapping.get(serviceClass);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends DriverService> Class<T> getServiceClass(
			Class<?> endpointClass) {
		return (Class<T>) serviceMapping.get(endpointClass);
	}

	public Map<Class<? extends DriverService>, Class<?>> getEndpointMapping() {
		return endpointMapping;
	}

	@SuppressWarnings("unchecked")
	public void setEndpointMapping(
			Map<Class<? extends DriverService>, Class<?>> endpointMapping) {
		this.endpointMapping = endpointMapping;

		for (Class<? extends DriverService> serviceClass : endpointMapping
				.keySet()) {
			Class<? extends DriverServiceEndpoint<?>> endpointClass = (Class<? extends DriverServiceEndpoint<?>>) 
					endpointMapping.get(serviceClass);

			this.serviceMapping.put(endpointClass, serviceClass);
		}
	}

	public Map<Class<? extends DriverService>, Class<? extends DriverService>> getClientMapping() {
		return clientMapping;
	}

	public void setClientMapping(
			Map<Class<? extends DriverService>, Class<? extends DriverService>> clientMapping) {
		this.clientMapping = clientMapping;
	}
}