package gr.uoa.di.driver.enabling.vocabulary;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.enabling.Vocabulary;

public class SQLVocabularyLoader implements VocabularyLoader {
	private static Logger logger = Logger.getLogger(SQLVocabularyLoader.class);
	private DataSource dataSource = null;
	private Map<String, String> queryMap = null;
	
	@Override
	public Vocabulary getVocabulary(String vocabularyName, Locale locale, Locale defaultLocale) {
		Vocabulary vocab = null;
		
		try {
			Connection con = dataSource.getConnection();
			Statement stmt = con.createStatement();
			String query = queryMap.get(vocabularyName);
			ResultSet rs = stmt.executeQuery(query);
			
			Map<String, String> map = new HashMap<String, String>();
			
			while (rs.next()) {
				map.put(rs.getString(2), rs.getString(1));
			}
			
			vocab = new Vocabulary(vocabularyName, map);
			
			rs.close();
			con.close();
			
		} catch (SQLException sqle) {
			logger.error("Error loading vocabulary " + vocabularyName, sqle);
		}

		return vocab;
	}

	public void setDataSource(DataSource dataSource) {
		this.dataSource = dataSource;
	}
	
	public void setQueryMap(Map<String, String> queryMap) {
		this.queryMap = queryMap;
	}
}
