/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailLibrary {
    private String mailhost = null;
    private String from = null;
    private String replyTo = null;
    private int smtpPort = 25;
    private String username = null;
    private String password = null;
    private boolean authenticate = false;
    private String mode = "plain";
    boolean debug = false;
    private Properties props = null;

    public void init() {
        this.props = new Properties();
        if (this.mode.equals("plain")) {
            this.props.put("mail.transport.protocol", "smtp");
            this.props.put("mail.smtp.host", this.mailhost);
            this.props.put("mail.smtp.port", (Object)this.smtpPort);
        } else if (this.mode.equals("ssl")) {
            this.props.put("mail.transport.protocol", "smtps");
            this.props.put("mail.smtps.host", this.mailhost);
            this.props.put("mail.smtps.port", (Object)this.smtpPort);
            this.props.put("mail.smtps.auth", "true");
            this.props.put("mail.smtps.user", this.username);
            this.props.put("mail.smtps.password", this.password);
        } else {
            throw new IllegalArgumentException("Unkown mode '" + this.mode + "'");
        }
        this.props.setProperty("mail.debug", this.debug + "");
    }

    public void sendEmail(String email, String subject, String text) throws AddressException, MessagingException {
        this.sendEmail(new String[]{email}, subject, text);
    }

    public void sendEmail(String[] recipients, String subject, String text) throws AddressException, MessagingException {
        Session session = Session.getInstance((Properties)this.props, (Authenticator)(this.authenticate ? new SMTPAuthenticator() : null));
        session.setDebug(this.debug);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.from));
        msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(this.replyTo)});
        msg.setSubject(subject, "UTF8");
        msg.setContent((Object)text, "text/plain; charset=UTF-8");
        for (String recipient : recipients) {
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        }
        Transport tr = session.getTransport();
        if (this.authenticate) {
            tr.connect(this.mailhost, this.smtpPort, this.username, this.password);
        } else {
            tr.connect();
        }
        tr.sendMessage((Message)msg, msg.getAllRecipients());
        tr.close();
    }

    public String getMailhost() {
        return this.mailhost;
    }

    public void setMailhost(String mailhost) {
        this.mailhost = mailhost;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(MailLibrary.this.username, MailLibrary.this.password);
        }
    }
}

