/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils;

import eu.dnetlib.domain.ServiceIdentity;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ServiceIdentityFactory {
    private static Logger logger = Logger.getLogger(ServiceIdentityFactory.class);

    public static ServiceIdentity createIdentity(String serviceName) {
        try {
            Properties properties = new Properties();
            properties.load(ServiceIdentityFactory.class.getClassLoader().getResourceAsStream(serviceName + ".properties"));
            String name = properties.getProperty("name");
            String label = properties.getProperty("label");
            String[] version = properties.getProperty("version").split("\\.");
            String major = version.length > 0 ? version[0] : null;
            String minor = version.length > 1 ? version[1] : null;
            String micro = version.length > 2 ? version[2] : null;
            return new ServiceIdentity(name, major, minor, micro, label);
        }
        catch (IOException e) {
            logger.error((Object)"Error creating service identity", (Throwable)e);
            return null;
        }
    }

    public static ServiceIdentity parseIdentity(String identity) {
        Pattern p = Pattern.compile("(.+)-(\\d)\\.(\\d)\\.(\\d)(-(.*))?");
        Matcher m = p.matcher(identity);
        if (m.find()) {
            String name = m.group(1);
            String major = m.group(2);
            String minor = m.group(3);
            String micro = m.group(4);
            String label = m.group(6);
            return new ServiceIdentity(name, major, minor, micro, label);
        }
        return null;
    }
}

