/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.app;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.domain.enabling.Subscription;
import gr.uoa.di.driver.enabling.issn.NotificationListener;
import gr.uoa.di.driver.enabling.issn.SNManager;
import gr.uoa.di.driver.enabling.issn.SubscriptionFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DriverServiceImpl
implements DriverService {
    private static Logger logger = Logger.getLogger(DriverServiceImpl.class);
    private SubscriptionFactory subscriptionFactory = new SubscriptionFactory();
    private volatile EPR serviceEPR = null;
    private ServiceIdentity serviceIdentity = null;
    private SNManager snManager = null;
    private Map<Subscription, NotificationListener> pendingSubscriptions = new HashMap<Subscription, NotificationListener>();
    private volatile boolean inititialized = false;

    public void init() {
        logger.debug((Object)("Service identity: " + this.serviceIdentity));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering pending subscriptions for service " + this.getClass().getSimpleName() + " with epr " + this.getServiceEPR()));
        }
        for (Map.Entry<Subscription, NotificationListener> entry : this.pendingSubscriptions.entrySet()) {
            Subscription sub = entry.getKey();
            NotificationListener listener = entry.getValue();
            sub.setEpr(this.getServiceEPR());
            this.snManager.subscribe(sub, listener);
        }
        this.pendingSubscriptions.clear();
        this.inititialized = true;
    }

    public void subscribe(ActionType actionType, ResourceType resourceType, NotificationListener listener) {
        Subscription sub = this.subscriptionFactory.createSubscription(actionType, resourceType, this.serviceEPR);
        this.addSubscription(sub, listener);
    }

    public void subscribe(ActionType actionType, ResourceType resourceType, String resourceId, NotificationListener listener) {
        Subscription sub = this.subscriptionFactory.createSubscription(actionType, resourceType, resourceId, this.serviceEPR);
        this.addSubscription(sub, listener);
    }

    public void subscribe(ActionType actionType, ResourceType resourceType, String resourceId, String path, NotificationListener listener) {
        Subscription sub = this.subscriptionFactory.createSubscription(actionType, resourceType, resourceId, path, this.serviceEPR);
        this.addSubscription(sub, listener);
    }

    private void addSubscription(Subscription sub, NotificationListener listener) {
        if (!this.isInititialized()) {
            logger.debug((Object)("Service " + this.getClass().getSimpleName() + " not yet initialized, adding subscription to queue."));
            this.pendingSubscriptions.put(sub, listener);
        } else if (this.snManager != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding subscription in service " + this.getClass().getSimpleName() + " with epr " + this.getServiceEPR()));
            }
            this.snManager.subscribe(sub, listener);
        } else {
            logger.warn((Object)"Service is initialized, but no subscription manager is present! Ignoring subscription.");
        }
    }

    public ServiceIdentity identify() {
        return this.serviceIdentity;
    }

    public void notify(Notification notification) throws DriverServiceException {
        this.snManager.notify(notification);
    }

    public boolean isInititialized() {
        return this.inititialized;
    }

    public void setServiceIdentity(ServiceIdentity serviceIdentity) {
        this.serviceIdentity = serviceIdentity;
    }

    public void setServiceEPR(EPR serviceEPR) {
        logger.debug((Object)("setting epr " + serviceEPR));
        this.serviceEPR = serviceEPR;
    }

    public EPR getServiceEPR() {
        return this.serviceEPR;
    }

    public SNManager getSnManager() {
        return this.snManager;
    }

    public void setSnManager(SNManager snManager) {
        this.snManager = snManager;
    }
}

