/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.dao;

import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.SearchCriteria;
import gr.uoa.di.driver.dao.DAOException;
import gr.uoa.di.driver.dao.GenericDAO;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.ISRegistry;
import gr.uoa.di.driver.enabling.ISRegistryException;
import java.util.List;
import org.apache.log4j.Logger;

public class GenericISDao<D extends DriverResource>
implements GenericDAO<D> {
    private static Logger loggger = Logger.getLogger(GenericISDao.class);
    protected ISLookUp<D> lookUp = null;
    protected ISRegistry<D> registry = null;

    public void setLookUp(ISLookUp<D> lookUp) {
        this.lookUp = lookUp;
    }

    public void setRegistry(ISRegistry<D> registry) {
        this.registry = registry;
    }

    @Override
    public D getById(String id) throws DAOException {
        try {
            return this.lookUp.getById(id);
        }
        catch (ISLookUpException ile) {
            throw new DAOException("Error getting object", ile);
        }
    }

    @Override
    public D save(D entity) throws DAOException {
        D object = null;
        try {
            object = this.registry.save(entity);
        }
        catch (ISRegistryException e) {
            throw new DAOException("Error saving profile", e);
        }
        return object;
    }

    @Override
    public void delete(D entity) throws DAOException {
        try {
            this.registry.delete(entity);
        }
        catch (ISRegistryException ire) {
            throw new DAOException("Error deleting object", ire);
        }
    }

    @Override
    public List<D> getAll() throws DAOException {
        try {
            return this.lookUp.fetch((SearchCriteria)null);
        }
        catch (ISLookUpException e) {
            throw new DAOException(e);
        }
    }

    @Override
    public List<D> search(SearchCriteria criteria) throws DAOException {
        try {
            loggger.debug((Object)"Performing search");
            return this.lookUp.fetch(criteria);
        }
        catch (ISLookUpException e) {
            loggger.error((Object)e);
            throw new DAOException(e);
        }
    }

    @Override
    public D getUniqueResult(SearchCriteria criteria) throws DAOException {
        List<D> results = null;
        try {
            results = this.lookUp.performQuickSearch(criteria);
        }
        catch (ISLookUpException e) {
            throw new DAOException("Error searching", e);
        }
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return (D)((DriverResource)results.get(0));
        }
        throw new DAOException("More than one results in query.");
    }
}

