/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.islookup;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import gr.uoa.di.driver.app.DriverServiceImpl;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.islookup.ISLookUpImpl;
import gr.uoa.di.driver.enabling.islookup.SecurityAwareLookupImpl;
import gr.uoa.di.driver.enabling.islookup.cache.CachingISLookUp;
import gr.uoa.di.driver.enabling.islookup.cache.DriverCacheManager;
import gr.uoa.di.driver.enabling.islookup.cache.LookUpEntryFactory;
import gr.uoa.di.driver.enabling.islookup.cache.SecurityAwareCacheManager;
import gr.uoa.di.driver.enabling.islookup.cache.SecurityAwareCachingISLookUp;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.SecurityProfileXmlConverter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;

public class ISLookUpFactory {
    private Map<Class<? extends DriverResource>, ISLookUp<? extends DriverResource>> lookUpMap = new HashMap<Class<? extends DriverResource>, ISLookUp<? extends DriverResource>>();
    private Map<Class<? extends DriverResource>, CachingISLookUp<? extends DriverResource>> cachingLookUpMap = new HashMap<Class<? extends DriverResource>, CachingISLookUp<? extends DriverResource>>();
    private Map<Class<? extends DriverResource>, Class<? extends Comparator<? extends DriverResource>>> comparatorClassMap = null;
    private ServiceLocator<ISLookUpService> lookupLocator = null;
    boolean useCache = false;
    private DriverServiceImpl service = null;
    private CacheManager cacheManager = null;
    private ResultSetFactory rsFactory = null;
    private Map<Class<? extends DriverResource>, Class<? extends ResourceToXmlConverter<? extends DriverResource>>> converterClassMap = null;
    private Map<Class<? extends DriverResource>, ResourceType> resourceTypeMap = null;

    public void init() throws JAXBException {
        ISLookUpImpl<SecurityProfile> lookup = new ISLookUpImpl<SecurityProfile>();
        lookup.setConverter(new SecurityProfileXmlConverter());
        lookup.setLookupLocator(this.lookupLocator);
        this.lookUpMap.put(SecurityProfile.class, lookup);
    }

    public <D extends DriverResource> ISLookUp<D> createISLookUp(Class<D> resourceClass) throws InstantiationException, IllegalAccessException {
        ISLookUp<? extends DriverResource> lookup = null;
        if (this.useCache) {
            CachingISLookUp<Object> cLookup = this.cachingLookUpMap.get(resourceClass);
            if (cLookup == null) {
                Ehcache idCache = this.getIdCache(resourceClass);
                Ehcache criteriaCache = this.getCriteriaCache(resourceClass);
                cLookup = new CachingISLookUp();
                cLookup.setConverter(this.getConverter(resourceClass));
                cLookup.setLookupLocator(this.lookupLocator);
                cLookup.setIdCache(idCache);
                cLookup.setCriteriaCache(criteriaCache);
                if (SecureDriverResource.class.isAssignableFrom(resourceClass)) {
                    SecurityAwareCachingISLookUp<Object> scLookup = new SecurityAwareCachingISLookUp<Object>();
                    scLookup.setLookup(cLookup);
                    scLookup.setSecurityLookup(this.lookUpMap.get(SecurityProfile.class));
                    cLookup = scLookup;
                }
                DriverCacheManager cacheManager = null;
                cacheManager = SecureDriverResource.class.isAssignableFrom(resourceClass) ? new SecurityAwareCacheManager() : new DriverCacheManager();
                cacheManager.setComparator(this.getComparator(resourceClass));
                cacheManager.setConverter(this.getConverter(resourceClass));
                cacheManager.setResourceType(this.getResourceType(resourceClass));
                cacheManager.setSecurityLookUp(this.lookUpMap.get(SecurityProfile.class));
                cacheManager.setIdCache(idCache);
                cacheManager.setCriteriaCache(criteriaCache);
                cacheManager.setService(this.service);
                cacheManager.init();
                this.cachingLookUpMap.put(resourceClass, cLookup);
            }
            lookup = cLookup;
        } else {
            lookup = this.lookUpMap.get(resourceClass);
            if (lookup == null) {
                lookup = new ISLookUpImpl<DriverResource>();
                ((ISLookUpImpl)lookup).setConverter(this.getConverter(resourceClass));
                ((ISLookUpImpl)lookup).setLookupLocator(this.lookupLocator);
                if (SecureDriverResource.class.isAssignableFrom(resourceClass)) {
                    SecurityAwareLookupImpl<? extends DriverResource> secureLookup = new SecurityAwareLookupImpl<DriverResource>();
                    secureLookup.setLookUp(lookup);
                    secureLookup.setSecurityLookUp(this.lookUpMap.get(SecurityProfile.class));
                    lookup = secureLookup;
                }
                this.lookUpMap.put(resourceClass, lookup);
            }
        }
        return lookup;
    }

    private <D extends DriverResource> ResourceToXmlConverter<D> getConverter(Class<D> resourceClass) throws InstantiationException, IllegalAccessException {
        Class<? extends ResourceToXmlConverter<? extends DriverResource>> converterClass = this.converterClassMap.get(resourceClass);
        return converterClass.newInstance();
    }

    private <D extends DriverResource> Comparator<D> getComparator(Class<D> resourceClass) throws InstantiationException, IllegalAccessException {
        Class<? extends Comparator<? extends DriverResource>> comparatorClass = this.comparatorClassMap.get(resourceClass);
        if (comparatorClass != null) {
            return comparatorClass.newInstance();
        }
        return null;
    }

    private <D extends DriverResource> ResourceType getResourceType(Class<D> resourceClass) {
        return this.resourceTypeMap.get(resourceClass);
    }

    private <D extends DriverResource> Ehcache getIdCache(Class<D> resourceClass) throws InstantiationException, IllegalAccessException {
        return this.createCache(resourceClass, resourceClass.getSimpleName() + ".id");
    }

    private <D extends DriverResource> Ehcache getCriteriaCache(Class<D> resourceClass) throws InstantiationException, IllegalAccessException {
        return this.createCache(resourceClass, resourceClass.getSimpleName() + ".criteria");
    }

    private <D extends DriverResource> Ehcache createCache(Class<D> resourceClass, String name) throws InstantiationException, IllegalAccessException {
        LookUpEntryFactory lookupFactory = new LookUpEntryFactory();
        lookupFactory.setLookUpServiceLocator(this.lookupLocator);
        lookupFactory.setRsFactory(this.rsFactory);
        this.cacheManager.addCache(name);
        Ehcache cache = this.cacheManager.getEhcache(name);
        return new SelfPopulatingCache(cache, lookupFactory);
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setService(DriverServiceImpl service) {
        this.service = service;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setConverterClassMap(Map<Class<? extends DriverResource>, Class<? extends ResourceToXmlConverter<? extends DriverResource>>> converterClassMap) {
        this.converterClassMap = converterClassMap;
    }

    public void setComparatorClassMap(Map<Class<? extends DriverResource>, Class<? extends Comparator<? extends DriverResource>>> comparatorClassMap) {
        this.comparatorClassMap = comparatorClassMap;
    }

    public void setResourceTypeMap(Map<Class<? extends DriverResource>, ResourceType> resourceTypeMap) {
        this.resourceTypeMap = resourceTypeMap;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }
}

