/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.registry;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.enabling.Notification;
import gr.uoa.di.driver.enabling.ISRegistry;
import gr.uoa.di.driver.enabling.ISRegistryException;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import org.apache.log4j.Logger;

public class CacheAwareRegistryImpl<D extends DriverResource>
implements ISRegistry<D> {
    private static Logger logger = Logger.getLogger(CacheAwareRegistryImpl.class);
    private ISRegistry<D> registry = null;
    private DriverService notificationService = null;
    private ResourceType resourceType = null;
    private ResourceToXmlConverter<D> converter = null;

    @Override
    public void delete(D object) throws ISRegistryException {
        logger.debug((Object)("Deleting object " + object.getResourceId()));
        this.registry.delete(object);
        this.sendNotification(ActionType.DELETE, object);
    }

    @Override
    public D insertForValidation(D object) throws ISRegistryException {
        return this.registry.insertForValidation(object);
    }

    @Override
    public D save(D object) throws ISRegistryException {
        boolean newObject = object.getResourceId() == null;
        logger.debug((Object)("saving object with id " + object.getResourceId()));
        object = this.registry.save(object);
        if (newObject) {
            this.sendNotification(ActionType.CREATE, object);
        } else {
            this.sendNotification(ActionType.UPDATE, object);
        }
        return object;
    }

    private void sendNotification(ActionType actionType, D object) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending immediate notification to cache: (" + actionType.getValue() + ", " + this.resourceType.getValue()));
            }
            Notification notification = new Notification(null, this.converter.ObjectToXml(object), object.getResourceId(), this.resourceType, actionType);
            this.notificationService.notify(notification);
        }
        catch (Exception e) {
            logger.error((Object)"Error notifying service", (Throwable)e);
        }
    }

    public void setRegistry(ISRegistry<D> registry) {
        this.registry = registry;
    }

    public void setNotificationService(DriverService notificationService) {
        this.notificationService = notificationService;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void setConverter(ResourceToXmlConverter<D> converter) {
        this.converter = converter;
    }
}

