/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.registry;

import eu.dnetlib.api.enabling.ISRegistryService;
import eu.dnetlib.api.enabling.ISRegistryServiceException;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.ISRegistry;
import gr.uoa.di.driver.enabling.ISRegistryException;
import gr.uoa.di.driver.util.ServiceLocator;
import org.apache.log4j.Logger;

public class SecurityAwareRegistryImpl<R extends SecureDriverResource>
implements ISRegistry<R> {
    private static Logger logger = Logger.getLogger(SecurityAwareRegistryImpl.class);
    private ServiceLocator<ISRegistryService> registryServiceLocator = null;
    private ISRegistry<R> registry = null;
    private ISRegistry<SecurityProfile> securityRegistry = null;
    private ISLookUp<SecurityProfile> securityLookUp = null;

    @Override
    public void delete(R object) throws ISRegistryException {
        this.securityRegistry.delete(object.getSecurityProfile());
        this.registry.delete(object);
    }

    @Override
    public R insertForValidation(R object) throws ISRegistryException {
        return (R)((SecureDriverResource)this.registry.insertForValidation(object));
    }

    @Override
    public R save(R object) throws ISRegistryException {
        if (object.getResourceId() == null) {
            return this.saveNew(object);
        }
        return this.update(object);
    }

    private R update(R object) throws ISRegistryException {
        try {
            SecurityProfile secProfile = object.getSecurityProfile();
            if (secProfile.getResourceId() == null) {
                SecurityProfile originalSecProfile = this.getOriginalSecProfile(object.getResourceId());
                secProfile.setResourceId(originalSecProfile.getResourceId());
                secProfile.setDateOfCreation(originalSecProfile.getDateOfCreation());
                secProfile.setResourceUri(originalSecProfile.getResourceUri());
                secProfile.setDriverResourceId(originalSecProfile.getDriverResourceId());
            }
            logger.debug((Object)"Updating profile");
            this.registry.save(object);
            logger.debug((Object)"Updating security profile");
            this.securityRegistry.save(secProfile);
            logger.debug((Object)"done");
            return object;
        }
        catch (ISLookUpException isle) {
            logger.error((Object)isle);
            throw new ISRegistryException("Error updating profile", isle);
        }
    }

    private R saveNew(R object) throws ISRegistryException {
        try {
            logger.debug((Object)"Saving new profile");
            logger.debug((Object)"registering secure resource: \n");
            object = (SecureDriverResource)this.registry.insertForValidation(object);
            logger.debug((Object)"registering secure profile: \n");
            SecurityProfile secProfile = this.securityRegistry.save(object.getSecurityProfile());
            logger.debug((Object)("binding profiles (" + object.getResourceId() + ", " + secProfile.getResourceId() + ")"));
            String profileId = this.registryServiceLocator.getService().registerSecureProfile(object.getResourceId(), secProfile.getResourceId());
            object.setResourceId(profileId);
            secProfile.setDriverResourceId(profileId);
            logger.debug((Object)"saving security profile (to save new resource id)");
            this.securityRegistry.save(secProfile);
            logger.debug((Object)"done");
            return object;
        }
        catch (ISRegistryServiceException e) {
            logger.error((Object)e);
            try {
                if (object.getResourceId() != null) {
                    this.registry.delete(object);
                }
                if (object.getSecurityProfile().getResourceId() != null) {
                    this.securityRegistry.delete(object.getSecurityProfile());
                }
            }
            catch (ISRegistryException isre) {
                logger.error((Object)isre);
            }
            throw new ISRegistryException("Error saving new profile", e);
        }
    }

    private SecurityProfile getOriginalSecProfile(String profileId) throws ISLookUpException {
        SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
        crit.getDriverResourceIds().add(profileId);
        return this.securityLookUp.getUniqueResult((SearchCriteria)crit);
    }

    public void setRegistryServiceLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryServiceLocator = registryLocator;
    }

    public void setRegistry(ISRegistry<R> registry) {
        this.registry = registry;
    }

    public void setSecurityRegistry(ISRegistry<SecurityProfile> securityRegistry) {
        this.securityRegistry = securityRegistry;
    }

    public void setSecurityLookUp(ISLookUp<SecurityProfile> securityLookUp) {
        this.securityLookUp = securityLookUp;
    }
}

