/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.Recommendation;
import eu.dnetlib.domain.functionality.RecommendationSearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.recommendation.ObjectFactory;
import gr.uoa.di.driver.xml.recommendation.RESOURCEPROFILE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class RecommendationXmlConverter
extends AbstractConverter<Recommendation>
implements ResourceToXmlConverter<Recommendation> {
    private ObjectFactory of = new ObjectFactory();

    public RecommendationXmlConverter() throws JAXBException {
        super(RESOURCEPROFILE.class);
    }

    @Override
    public String ObjectToXml(Recommendation recommendation) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RESOURCEPROFILE profile = this.of.createRESOURCEPROFILE();
        profile.setHEADER(this.of.createHEADERType());
        profile.setBODY(this.of.createBODYType());
        profile.getHEADER().setRESOURCEIDENTIFIER(this.of.createRESOURCEIDENTIFIERType());
        profile.getHEADER().setRESOURCEKIND(this.of.createRESOURCEKINDType());
        profile.getHEADER().setRESOURCETYPE(this.of.createRESOURCETYPEType());
        profile.getHEADER().setRESOURCEURI(this.of.createRESOURCEURIType());
        profile.getHEADER().setDATEOFCREATION(this.of.createDATEOFCREATIONType());
        profile.getHEADER().getRESOURCEKIND().setValue(recommendation.getResourceKind());
        profile.getHEADER().getRESOURCETYPE().setValue(recommendation.getResourceType());
        if (recommendation.getDateOfCreation() != null) {
            profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.DateToString(recommendation.getDateOfCreation()));
        } else {
            profile.getHEADER().getDATEOFCREATION().setValue("");
        }
        if (recommendation.getResourceId() != null) {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue(recommendation.getResourceId());
        } else {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
        }
        if (recommendation.getResourceUri() != null) {
            profile.getHEADER().getRESOURCEURI().setValue(recommendation.getResourceUri());
        } else {
            profile.getHEADER().getRESOURCEURI().setValue("");
        }
        profile.getBODY().setSECURITYPARAMETERS(this.of.createSECURITYPARAMETERSType());
        profile.getBODY().getSECURITYPARAMETERS().setSECURITYPARAMETER("value");
        profile.getBODY().setCONFIGURATION(this.of.createCONFIGURATIONType());
        profile.getBODY().getCONFIGURATION().setRECOMMENDATIONINFO(this.of.createRECOMMENDATIONINFOType());
        profile.getBODY().setSTATUS("value");
        profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().setRECOMMENDATIONTEXT(recommendation.getContent());
        profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().setDATEOFEXPIRATION(this.of.createRECOMMENDATIONINFOTypeDATEOFEXPIRATION());
        profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getDATEOFEXPIRATION().setValue(ConversionUtils.toXMLGregorianCalendar(recommendation.getExpirationDate()).toString());
        profile.getBODY().setINDEX(recommendation.getIndex());
        profile.getBODY().setACTIVE(recommendation.isActive());
        profile.getBODY().setTITLE(recommendation.getTitle());
        if (recommendation.getType().equals("Announcement")) {
            profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().setTYPE("Announcement");
        } else if (recommendation.getType().equals("Community")) {
            profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().setTYPE("Community");
            profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().setCOMMUNITIES(this.of.createCOMMUNITIESType());
            if (recommendation.getCommunityIds() != null) {
                for (String communityId : recommendation.getCommunityIds()) {
                    profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getCOMMUNITIES().getCOMMUNITYID().add(communityId);
                }
            }
        } else {
            profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().setTYPE("User");
            profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().setUSERS(this.of.createUSERSType());
            if (recommendation.getUserIds() != null) {
                for (String userId : recommendation.getUserIds()) {
                    profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getUSERS().getUSERID().add(userId);
                }
            }
        }
        this.getMarshaller().marshal((Object)profile, (OutputStream)baos);
        return baos.toString();
    }

    @Override
    public Recommendation XmlToObject(String xml) throws JAXBException {
        int i;
        Recommendation recommendation = new Recommendation();
        RESOURCEPROFILE profile = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        recommendation.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER().getValue());
        recommendation.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
        recommendation.setGenerationDate(ConversionUtils.parseDate(profile.getHEADER().getDATEOFCREATION().getValue()));
        recommendation.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
        recommendation.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
        recommendation.setContent(profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getRECOMMENDATIONTEXT());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss");
        Date expirationDate = new Date();
        try {
            String date = profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getDATEOFEXPIRATION().getValue();
            expirationDate = formatter.parse(date);
        }
        catch (ParseException ex) {
            Logger.getLogger(RecommendationXmlConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        recommendation.setExpirationDate(expirationDate);
        recommendation.setType(profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getTYPE());
        recommendation.setActive(profile.getBODY().isACTIVE().booleanValue());
        recommendation.setIndex(profile.getBODY().getINDEX().intValue());
        recommendation.setTitle(profile.getBODY().getTITLE());
        if (profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getCOMMUNITIES() != null) {
            HashSet<String> communities = new HashSet<String>();
            if (profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getCOMMUNITIES().getCOMMUNITYID() != null) {
                for (i = 0; i < profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getCOMMUNITIES().getCOMMUNITYID().size(); ++i) {
                    communities.add(profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getCOMMUNITIES().getCOMMUNITYID().get(i));
                }
                recommendation.setCommunityIds(communities);
            }
        }
        if (profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getUSERS() != null) {
            HashSet<String> users = new HashSet<String>();
            if (profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getUSERS().getUSERID() != null) {
                for (i = 0; i < profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getUSERS().getUSERID().size(); ++i) {
                    users.add(profile.getBODY().getCONFIGURATION().getRECOMMENDATIONINFO().getUSERS().getUSERID().get(i));
                }
                recommendation.setUserIds(users);
            }
        }
        return recommendation;
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((RecommendationSearchCriteria)criteria);
    }

    public String toXQueryString(RecommendationSearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        String xQuery = null;
        ArrayList<String> predicates = new ArrayList<String>();
        xQuery = "for $x in collection( \"/db/DRIVER/RecommendationDSResources/RecommendationDSResourceType\" )";
        if (criteria.getExpiredAfter() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RECOMMENDATION_INFO/DATE_OF_EXPIRATION[@value > \"" + ConversionUtils.toXMLGregorianCalendar(criteria.getExpiredAfter()) + "\"]");
        }
        if (criteria.getExpiredBefore() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RECOMMENDATION_INFO/DATE_OF_EXPIRATION[@value < \"" + ConversionUtils.toXMLGregorianCalendar(criteria.getExpiredAfter()) + "\"]");
        }
        if (criteria.getRecommendationType() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RECOMMENDATION_INFO[TYPE = \"" + criteria.getRecommendationType() + "\"]");
        }
        if (criteria.getCommunityId() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RECOMMENDATION_INFO/COMMUNITIES[COMMUNITY_ID = \"" + criteria.getCommunityId() + "\"]");
        }
        if (criteria.getUserId() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RECOMMENDATION_INFO/USERS[USER_ID = \"" + criteria.getUserId() + "\"]");
        }
        if (criteria.getActive() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/ACTIVE[. = '" + criteria.getActive() + "']");
        }
        for (int i = 0; i < predicates.size(); ++i) {
            String predicate = (String)predicates.get(i);
            xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
            xQuery = xQuery + predicate;
        }
        xQuery = xQuery + " return $x";
        return xQuery;
    }

    @Deprecated
    public String toXQueryString(Recommendation exampleInstance) {
        String xQuery = "for $x in collection( \"/db/DRIVER/RecommendationDSResources/RecommendationDSResourceType\" )";
        ArrayList<String> predicates = new ArrayList<String>();
        if (exampleInstance != null) {
            if (exampleInstance.getId() != null) {
                predicates.add("$x/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER[@value=\"" + exampleInstance.getId() + "\"]");
            }
            if (exampleInstance.getContent() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RECOMMENDATION_INFO[RECOMMENDATION_TEXT = \"" + exampleInstance.getContent() + "\"]");
            }
            if (exampleInstance.getType() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RECOMMENDATION_INFO[TYPE = \"" + exampleInstance.getType() + "\"]");
            }
            for (int i = 0; i < predicates.size(); ++i) {
                String predicate = (String)predicates.get(i);
                xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
                xQuery = xQuery + predicate;
            }
        }
        xQuery = xQuery + " return $x";
        return xQuery;
    }
}

