package gr.uoa.di.driver.enabling.islookup.cache;

import eu.dnetlib.domain.SearchCriteria;

public class CriteriaCacheKey {
	private SearchCriteria criteria = null;
	private String XQuery = null;

	public CriteriaCacheKey(SearchCriteria criteria) {
		this.criteria = criteria;
	}

	public SearchCriteria getCriteria() {
		return criteria;
	}

	public void setCriteria(SearchCriteria criteria) {
		this.criteria = criteria;
	}

	public String getXQuery() {
		return this.XQuery;
	}

	public void setXQuery(String XQuery) {
		this.XQuery = XQuery;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		CriteriaCacheKey that = (CriteriaCacheKey) o;

		if (criteria != null ? !criteria.equals(that.criteria) : that.criteria != null) return false;
		return XQuery != null ? XQuery.equals(that.XQuery) : that.XQuery == null;
	}

	@Override
	public int hashCode() {
		int result = criteria != null ? criteria.hashCode() : 0;
		result = 31 * result + (XQuery != null ? XQuery.hashCode() : 0);
		return result;
	}
}
