package gr.uoa.di.driver.enabling.resultset;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBException;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ResultSetService;
import eu.dnetlib.api.enabling.ResultSetServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.util.ObjectToXmlConverter;

public class ResultSetImpl<D> implements ResultSet<D> {
	static Logger logger = Logger.getLogger(ResultSetImpl.class);
	private EPR epr = null;

	static ObjectToXmlConverter<String> dummyConverter = new ObjectToXmlConverter<String>() {
		public String XmlToObject(String xml) throws JAXBException {
			return xml;
		}

		public String ObjectToXml(String object) throws JAXBException {
			return object;
		}
	};

	private String identifier = null;
	private ObjectToXmlConverter<D> converter = null;
	private ResultSetService rsService = null;

	@SuppressWarnings("unchecked")
	public ResultSetImpl(ResultSetService rsService, String rsIdentifier) {
		this(rsService, rsIdentifier, (ObjectToXmlConverter<D>) dummyConverter);
	}

	public ResultSetImpl(ResultSetService rsService, String rsIdentifier,
			ObjectToXmlConverter<D> converter) {
		this.identifier = rsIdentifier;
		this.converter = converter;
		this.rsService = rsService;
	}

	public boolean isOpen() {
		boolean open = false;

		try {
			String status = rsService.getRSStatus(identifier);
			open = status.toLowerCase().equals("open");
		} catch (ResultSetServiceException e) {
			logger.warn("Result Set Error.", e);
		}
		return open;
	}

	public boolean isAlive() {
		try {
			rsService.getNumberOfElements(identifier);
		} catch (ResultSetServiceException rsse) {
			// TODO: something??? nothing

			return false;
		}

		return true;
	}

	public void close() {
		rsService.closeRS(identifier);
	}

	public int size() {
		int size = 0;

		try {
			size = rsService.getNumberOfElements(identifier);
		} catch (ResultSetServiceException e) {
			logger.warn("Result Set Error.", e);
		}

		return size;
	}

	public List<String> getElements(int from, int to) {
		List<String> elements = null;

		try {
			elements = rsService.getResult(identifier, from, to, "waiting");
		} catch (ResultSetServiceException e) {
			logger.warn("Result Set Error.", e);
		}

		return elements;
	}

	public List<D> get(int from, int to) {
		List<String> elements = getElements(from, to);
		List<D> list = null;
		if (elements != null) {
			list = new ArrayList<D>(elements.size());
			for (String element : elements) {
				try {
					D d = converter.XmlToObject(element);
					list.add(d);
				} catch (JAXBException e) {
					logger.warn("Error converting element: " + element);
				}
			}
		}
		return list;
	}

	public EPR getEpr() {
		return epr;
	}

	public void setEpr(EPR epr) {
		this.epr = epr;
	}
}
