package eu.dnetlib.utils;

import java.util.Properties;

import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailLibrary {
	private String mailhost = null;
	private String from = null;
	private String replyTo = null;
	private int smtpPort = 25;
	private String username = null;
	private String password = null;
	private boolean authenticate = false;
	private String mode = "plain";
	boolean debug = false;

	private Properties props = null;

	public void init() {
		props = new Properties();

		if (mode.equals("plain")) {
			props.put("mail.transport.protocol", "smtp");

			props.put("mail.smtp.host", mailhost);
			props.put("mail.smtp.port", smtpPort);
		} else if (mode.equals("ssl")) {
			props.put("mail.transport.protocol", "smtps");

			props.put("mail.smtps.host", mailhost);
			props.put("mail.smtps.port", smtpPort);
			props.put("mail.smtps.auth", "true");
			props.put("mail.smtps.user", username);
			props.put("mail.smtps.password", password);
		} else {
			throw new IllegalArgumentException("Unkown mode '" + mode + "'");
		}

		props.setProperty("mail.debug", this.debug + "");
	}

	public void sendEmail(String email, String subject, String text) throws AddressException, MessagingException {
		sendEmail(new String[] { email }, subject, text);
	}

	public void sendEmail(String[] recipients, String subject, String text) throws AddressException, MessagingException {
		Session session = Session.getInstance(props,
				(this.authenticate ? new SMTPAuthenticator() : null));

		session.setDebug(debug);

		MimeMessage msg = new MimeMessage(session);

		msg.setFrom(new InternetAddress(this.from));
		msg.setReplyTo(new InternetAddress[] { new InternetAddress(replyTo) });
		msg.setSubject(subject, "UTF8");
		msg.setContent(text, "text/plain; charset=UTF-8");

		for (String recipient : recipients)
			msg.addRecipient(javax.mail.Message.RecipientType.TO,
					new InternetAddress(recipient));

		Transport tr = session.getTransport();

		if (authenticate) {
			tr.connect(mailhost, smtpPort, username, password);
		} else {
			tr.connect();
		}

		tr.sendMessage(msg, msg.getAllRecipients());
		tr.close();
	}

	private class SMTPAuthenticator extends javax.mail.Authenticator {
		public PasswordAuthentication getPasswordAuthentication() {
			return new PasswordAuthentication(username, password);
		}
	}

	public String getMailhost() {
		return mailhost;
	}

	public void setMailhost(String mailhost) {
		this.mailhost = mailhost;
	}

	public String getFrom() {
		return from;
	}

	public void setFrom(String from) {
		this.from = from;
	}

	public String getReplyTo() {
		return replyTo;
	}

	public void setReplyTo(String replyTo) {
		this.replyTo = replyTo;
	}

	public int getSmtpPort() {
		return smtpPort;
	}

	public void setSmtpPort(int smtpPort) {
		this.smtpPort = smtpPort;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public boolean isAuthenticate() {
		return authenticate;
	}

	public void setAuthenticate(boolean authenticate) {
		this.authenticate = authenticate;
	}

	public String getMode() {
		return mode;
	}

	public void setMode(String mode) {
		this.mode = mode;
	}

	public boolean isDebug() {
		return debug;
	}

	public void setDebug(boolean debug) {
		this.debug = debug;
	}
}
