package eu.dnetlib.utils.hibernate;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
	private String host;
	private String catalog;
	private String username;
	private String password;
	private SessionFactory sessionFactory;
	private Logger logger = Logger.getLogger(this.getClass());

	public HibernateUtil() {
	}

	public HibernateUtil(String host, String catalog, String username,
			String password) {
		super();
		this.host = host;
		this.catalog = catalog;
		this.username = username;
		this.password = password;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Session getSession() {
		if ((sessionFactory == null) || sessionFactory.isClosed())
			this.configure();

		return sessionFactory.getCurrentSession();
	}

	private void configure() {
		Configuration configuration = new AnnotationConfiguration().configure();
		String url = "jdbc:mysql://" + host + "/" + catalog
				+ "?characterEncoding=UTF-8";
		configuration.setProperty("hibernate.connection.url", url);
		configuration.setProperty("hibernate.connection.username", username);
		configuration.setProperty("hibernate.connection.password", password);

		if (logger.isDebugEnabled())
			logger.debug("Connecting to url " + url + ", username: " + username
					+ ", password: " + password);
		
		this.sessionFactory = configuration.buildSessionFactory();
	}

	public SessionFactory getSessionFactory() {
		if ((sessionFactory == null) || sessionFactory.isClosed())
			this.configure();
		
		return sessionFactory;
	}

	public void setSessionFactory(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}
}
