package gr.uoa.di.driver.enabling.vocabulary;

import eu.dnetlib.api.data.DatasourceManagerService;
import eu.dnetlib.api.data.DatasourceManagerServiceException;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.enabling.Vocabulary;
import gr.uoa.di.driver.util.ServiceLocator;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class RepositoryVocabularyLoader implements VocabularyLoader {
	
    private ServiceLocator<DatasourceManagerService> datasourceManagerService = null;

	private Logger logger = Logger.getLogger(RepositoryVocabularyLoader.class);

	public Vocabulary getVocabulary(String vocabularyName, Locale locale, Locale defaultloLocale) {

        List<Repository> repositories = null;

        try {
            repositories = datasourceManagerService.getService().listAllDatasources();

		} catch (DatasourceManagerServiceException e) {
            logger.error("Error getting repositories.", e);
        }
		
		Map<String, String> map = new TreeMap<String, String>();
		
		for (Repository rep:repositories)
			map.put(rep.getOfficialName(), rep.getOfficialName());
		
		Vocabulary vocabulary = new Vocabulary(vocabularyName, map);
		
		return vocabulary;
	}

    public void setDatasourceManagerService(ServiceLocator<DatasourceManagerService> datasourceManagerService) {
        this.datasourceManagerService = datasourceManagerService;
    }
}
