/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.islookup.cache;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.domain.DriverResource;
import gr.uoa.di.driver.enabling.islookup.cache.CriteriaCacheKey;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.List;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.log4j.Logger;

public class LookUpEntryFactory<D extends DriverResource>
implements CacheEntryFactory {
    private Logger logger = Logger.getLogger(this.getClass());
    private ServiceLocator<ISLookUpService> lookUpServiceLocator = null;
    private ResultSetFactory rsFactory = null;

    public Object createEntry(Object key) throws Exception {
        Object entry = null;
        if (key instanceof String) {
            entry = this.getById((String)key);
        } else if (key instanceof CriteriaCacheKey) {
            CriteriaCacheKey args = (CriteriaCacheKey)key;
            String XQuery = args.getXQuery();
            entry = this.getByCriteria(XQuery);
        } else {
            this.logger.warn((Object)"key is not id or query");
            this.logger.warn((Object)("key is: " + key + "(" + key.getClass() + ")"));
        }
        return entry;
    }

    private List<String> getByCriteria(String XQuery) throws ISLookUpServiceException {
        return this.lookUpServiceLocator.getService().quickSearchProfile(XQuery);
    }

    private String getById(String key) throws ISLookUpServiceException {
        return this.lookUpServiceLocator.getService().getResourceProfile(key);
    }

    public ServiceLocator<ISLookUpService> getLookUpServiceLocator() {
        return this.lookUpServiceLocator;
    }

    public void setLookUpServiceLocator(ServiceLocator<ISLookUpService> lookUpServiceLocator) {
        this.lookUpServiceLocator = lookUpServiceLocator;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }
}

