/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.Collection;
import eu.dnetlib.domain.functionality.CollectionSearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.collection.BASKETDOCUMENTType;
import gr.uoa.di.driver.xml.collection.CHILDType;
import gr.uoa.di.driver.xml.collection.FIELDType;
import gr.uoa.di.driver.xml.collection.ObjectFactory;
import gr.uoa.di.driver.xml.collection.RESOURCEPROFILE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CollectionXmlConverter
extends AbstractConverter<Collection>
implements ResourceToXmlConverter<Collection> {
    private ObjectFactory of = new ObjectFactory();

    public CollectionXmlConverter() throws JAXBException {
        super(RESOURCEPROFILE.class);
    }

    @Override
    public String ObjectToXml(Collection collection) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RESOURCEPROFILE profile = this.of.createRESOURCEPROFILE();
        profile.setHEADER(this.of.createHEADERType());
        profile.setBODY(this.of.createBODYType());
        profile.getHEADER().setRESOURCEIDENTIFIER(this.of.createRESOURCEIDENTIFIERType());
        profile.getHEADER().setRESOURCEKIND(this.of.createRESOURCEKINDType());
        profile.getHEADER().setRESOURCETYPE(this.of.createRESOURCETYPEType());
        profile.getHEADER().setRESOURCEURI(this.of.createRESOURCEURIType());
        profile.getHEADER().setDATEOFCREATION(this.of.createDATEOFCREATIONType());
        if (collection.getDateOfCreation() != null) {
            profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.DateToString(collection.getDateOfCreation()));
        } else {
            profile.getHEADER().getDATEOFCREATION().setValue("");
        }
        if (collection.getResourceId() != null) {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue(collection.getResourceId());
        } else {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
        }
        if (collection.getResourceUri() != null) {
            profile.getHEADER().getRESOURCEURI().setValue(collection.getResourceUri());
        } else {
            profile.getHEADER().getRESOURCEURI().setValue("");
        }
        profile.getHEADER().getRESOURCEKIND().setValue(collection.getResourceKind());
        profile.getHEADER().getRESOURCETYPE().setValue(collection.getResourceType());
        profile.getBODY().setSECURITYPARAMETERS("");
        profile.getBODY().setCONFIGURATION(this.of.createCONFIGURATIONType());
        profile.getBODY().setSTATUS(this.of.createSTATUSType());
        profile.getBODY().getSTATUS().setCOUNTDOCS(this.of.createCOUNTDOCSType());
        if (collection.getLastUpdateDate() != null) {
            profile.getBODY().getSTATUS().getCOUNTDOCS().setLastUpdate(ConversionUtils.DateToString(collection.getLastUpdateDate()));
        } else {
            profile.getBODY().getSTATUS().getCOUNTDOCS().setLastUpdate("");
        }
        profile.getBODY().getSTATUS().getCOUNTDOCS().setNumber(collection.getDocumentCount());
        profile.getBODY().getSTATUS().setRETRIEVALCONDITION(this.of.createRETRIEVALCONDITIONType());
        profile.getBODY().getSTATUS().getRETRIEVALCONDITION().setFrozen(collection.isFrozen() ? 1 : 0);
        profile.getBODY().getSTATUS().getRETRIEVALCONDITION().setContent(collection.getRetrievalCondition());
        profile.getBODY().getCONFIGURATION().setDESCRIPTION(this.of.createDESCRIPTIONType());
        if (collection.getDescription().size() > 0) {
            for (int i = 0; i < collection.getDescription().size(); ++i) {
                String s = (String)collection.getDescription().get(i);
                FIELDType type = new FIELDType();
                type.setContent(s);
                type.setOrd(i);
                type.setLabel("description");
                profile.getBODY().getCONFIGURATION().getDESCRIPTION().getFIELD().add(type);
            }
        } else {
            FIELDType type = new FIELDType();
            type.setContent("-");
            type.setOrd(0);
            type.setLabel("description");
            profile.getBODY().getCONFIGURATION().getDESCRIPTION().getFIELD().add(type);
        }
        if (collection.getName() != null) {
            profile.getBODY().getCONFIGURATION().setNAME(collection.getName());
        } else {
            profile.getBODY().getCONFIGURATION().setNAME("");
        }
        profile.getBODY().getCONFIGURATION().setOWNER(this.of.createOWNERType());
        if (collection.getOwner() != null) {
            profile.getBODY().getCONFIGURATION().getOWNER().setId(collection.getOwner());
        } else {
            profile.getBODY().getCONFIGURATION().getOWNER().setId("");
        }
        if (collection.getIconUrl() != null) {
            profile.getBODY().getCONFIGURATION().setIMAGEURL(collection.getIconUrl());
            profile.getBODY().getCONFIGURATION().setICONURI(collection.getIconUrl());
        } else {
            profile.getBODY().getCONFIGURATION().setIMAGEURL("");
            profile.getBODY().getCONFIGURATION().setICONURI("");
        }
        if (collection.getSubject() != null) {
            profile.getBODY().getCONFIGURATION().setSUBJECT(collection.getSubject());
        } else {
            profile.getBODY().getCONFIGURATION().setSUBJECT("");
        }
        if (collection.getQuery() != null) {
            profile.getBODY().getCONFIGURATION().setMEMBERSHIPCONDITION(collection.getQuery());
        } else {
            profile.getBODY().getCONFIGURATION().setMEMBERSHIPCONDITION("");
        }
        profile.getBODY().getCONFIGURATION().setVISIBLE(collection.isVisible() ? 1 : 0);
        profile.getBODY().getCONFIGURATION().setPRIVATE(collection.isPrivate() ? 1 : 0);
        profile.getBODY().getCONFIGURATION().setCONTAINER(collection.isContainer() ? 1 : 0);
        profile.getBODY().getCONFIGURATION().setFATHER(this.of.createFATHERType());
        if (collection.getFather() != null) {
            profile.getBODY().getCONFIGURATION().getFATHER().setId(collection.getFather());
        } else {
            profile.getBODY().getCONFIGURATION().getFATHER().setId("InfoSpace");
        }
        profile.getBODY().getCONFIGURATION().setCHILDREN(this.of.createCHILDRENType());
        for (String child : collection.getChildren()) {
            CHILDType childType = this.of.createCHILDType();
            childType.setId(child);
            profile.getBODY().getCONFIGURATION().getCHILDREN().getCHILD().add(childType);
        }
        if (collection.getDocumentsInBasket().size() > 0) {
            profile.getBODY().getCONFIGURATION().setBASKET(this.of.createBASKETType());
            for (String documentId : collection.getDocumentsInBasket()) {
                BASKETDOCUMENTType documentType = this.of.createBASKETDOCUMENTType();
                documentType.setId(documentId);
                profile.getBODY().getCONFIGURATION().getBASKET().getDOCUMENT().add(documentType);
            }
        }
        this.getMarshaller().marshal((Object)profile, (OutputStream)baos);
        return baos.toString();
    }

    @Override
    public Collection XmlToObject(String xml) throws JAXBException {
        Collection collection = new Collection();
        RESOURCEPROFILE profile = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        collection.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER().getValue());
        collection.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
        collection.setResourceKind(collection.getResourceKind());
        collection.setResourceType(collection.getResourceType());
        collection.setDateOfCreation(ConversionUtils.parseDate(profile.getHEADER().getDATEOFCREATION().getValue()));
        collection.setName(profile.getBODY().getCONFIGURATION().getNAME());
        collection.setOwner(profile.getBODY().getCONFIGURATION().getOWNER().getId());
        collection.setIconUrl(profile.getBODY().getCONFIGURATION().getIMAGEURL());
        if (!profile.getBODY().getCONFIGURATION().getFATHER().getId().toLowerCase().equals("infospace")) {
            collection.setFather(profile.getBODY().getCONFIGURATION().getFATHER().getId());
        }
        collection.setSubject(profile.getBODY().getCONFIGURATION().getSUBJECT());
        collection.setPrivate(profile.getBODY().getCONFIGURATION().getPRIVATE() == 1);
        collection.setVisible(profile.getBODY().getCONFIGURATION().getVISIBLE() == 1);
        collection.setContainer(profile.getBODY().getCONFIGURATION().getCONTAINER() == 1);
        collection.setQuery(profile.getBODY().getCONFIGURATION().getMEMBERSHIPCONDITION());
        collection.setDocumentCount(profile.getBODY().getSTATUS().getCOUNTDOCS().getNumber());
        collection.setFrozen(profile.getBODY().getSTATUS().getRETRIEVALCONDITION().getFrozen() == 1);
        collection.setRetrievalCondition(profile.getBODY().getSTATUS().getRETRIEVALCONDITION().getContent());
        List<CHILDType> children = profile.getBODY().getCONFIGURATION().getCHILDREN().getCHILD();
        HashSet<String> set = new HashSet<String>();
        for (CHILDType child : children) {
            set.add(child.getId());
        }
        collection.setChildren(set);
        if (profile.getBODY().getCONFIGURATION().getBASKET() != null) {
            List<BASKETDOCUMENTType> documents = profile.getBODY().getCONFIGURATION().getBASKET().getDOCUMENT();
            for (BASKETDOCUMENTType document : documents) {
                collection.getDocumentsInBasket().add(document.getId());
            }
        }
        List<FIELDType> collections = profile.getBODY().getCONFIGURATION().getDESCRIPTION().getFIELD();
        for (FIELDType ftype : collections) {
            collection.getDescription().add(ftype.getContent());
        }
        if (profile.getBODY().getSTATUS().getCOUNTDOCS().getLastUpdate() != null && !profile.getBODY().getSTATUS().getCOUNTDOCS().getLastUpdate().trim().equals("")) {
            collection.setLastUpdateDate(ConversionUtils.parseDate(profile.getBODY().getSTATUS().getCOUNTDOCS().getLastUpdate()));
        } else {
            collection.setLastUpdateDate(null);
        }
        return collection;
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((CollectionSearchCriteria)criteria);
    }

    public String toXQueryString(CollectionSearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        ArrayList<String> predicates = new ArrayList<String>();
        String xQuery = null;
        if (criteria.getContains() != null) {
            predicates.add("$x//CONFIGURATION/NAME[contains(lower-case(.), \"" + criteria.getContains().toLowerCase() + "\")]");
        }
        if (criteria.getStartsWith() != null) {
            predicates.add("$x//CONFIGURATION/NAME[starts-with(lower-case(.), \"" + criteria.getStartsWith().toLowerCase() + "\")]");
        }
        if (criteria.getEndsWith() != null) {
            predicates.add("$x//CONFIGURATION/NAME[ends-with(lower-case(.), \"" + criteria.getEndsWith().toLowerCase() + "\")]");
        }
        if (criteria.getParentId() != null) {
            predicates.add("$x//CONFIGURATION/FATHER[@id=\"" + criteria.getParentId() + "\"]");
        }
        if (criteria.getRoot() != null) {
            if (criteria.getRoot().booleanValue()) {
                predicates.add("$x//CONFIGURATION/FATHER[@id=\"InfoSpace\"]");
            } else {
                predicates.add("$x//CONFIGURATION/FATHER[@id != \"InfoSpace\"]");
            }
        }
        if (criteria.getOwnerId() != null) {
            predicates.add("$x//CONFIGURATION/OWNER[@id=\"" + criteria.getOwnerId() + "\"] ");
        }
        if (criteria.getIsPrivate() != null) {
            if (criteria.getIsPrivate().booleanValue()) {
                predicates.add(" $x//RESOURCE_PROFILE/BODY/CONFIGURATION[PRIVATE = 1] ");
            } else {
                predicates.add(" $x//RESOURCE_PROFILE/BODY/CONFIGURATION[PRIVATE = 0] ");
            }
        }
        if (criteria.getIsContainer() != null) {
            if (criteria.getIsContainer().booleanValue()) {
                predicates.add(" $x//RESOURCE_PROFILE/BODY/CONFIGURATION[CONTAINER = 1] ");
            } else {
                predicates.add(" $x//RESOURCE_PROFILE/BODY/CONFIGURATION[CONTAINER = 0] ");
            }
        }
        if (criteria.getName() != null) {
            predicates.add("$x//CONFIGURATION[NAME =\"" + criteria.getName() + "\"]");
        }
        xQuery = "for $x in collection(\"/db/DRIVER/CollectionDSResources/CollectionDSResourceType\")";
        for (int i = 0; i < predicates.size(); ++i) {
            String predicate = (String)predicates.get(i);
            xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
            xQuery = xQuery + predicate;
        }
        xQuery = xQuery + " order by $x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME";
        xQuery = xQuery + " return $x";
        return xQuery;
    }

    @Deprecated
    public String toXQueryString(Collection collection) {
        String xQuery = "for $x in collection(\"/db/DRIVER/CollectionDSResources/CollectionDSResourceType\") ";
        ArrayList<String> predicates = new ArrayList<String>();
        if (collection != null) {
            if (collection.getResourceId() != null) {
                predicates.add("$x/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER[@value=\"" + collection.getResourceId() + "\"]");
            }
            if (collection.getName() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/[NAME=\"" + collection.getName() + "\"]");
            }
            if (collection.getOwner() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OWNER[@id=\"" + collection.getOwner() + "\"]");
            }
            if (collection.getFather() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/FATHER[@id=\"" + collection.getFather() + "\"]");
            }
            if (collection.getSubject() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/[SUBJECT=\"" + collection.getSubject() + "\"]");
            }
            if (collection.getQuery() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/[MEMBERSHIP_CONDITION=\"" + collection.getQuery() + "\"]");
            }
            if (collection.isPrivate()) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/[PRIVATE = " + (collection.isPrivate() ? 1 : 0) + "]");
            }
            if (collection.isVisible()) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/[VISIBLE = " + (collection.isVisible() ? 1 : 0) + "]");
            }
            if (collection.isContainer()) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/[CONTAINER = " + (collection.isContainer() ? 1 : 0) + "]");
            }
            if (collection.isFrozen()) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/STATUS/RETRIEVAL_CONDITION[@frozen = " + (collection.isFrozen() ? 1 : 0) + "]");
            }
            if (collection.getDocumentCount() > 0) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/STATUS/COUNT_DOCS[@number = " + collection.getDocumentCount() + "]");
            }
            if (collection.getLastUpdateDate() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/STATUS/COUNT_DOCS[@last_update=\"" + ConversionUtils.DateToString(collection.getLastUpdateDate()) + "\"]");
            }
            for (int i = 0; i < predicates.size(); ++i) {
                String predicate = (String)predicates.get(i);
                xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
                xQuery = xQuery + predicate;
            }
        }
        xQuery = xQuery + " return $x";
        return xQuery;
    }

    public static void main(String[] args) throws JAXBException {
        CollectionXmlConverter conv = new CollectionXmlConverter();
        CollectionSearchCriteria criteria = new CollectionSearchCriteria();
        criteria.setRoot(Boolean.valueOf(true));
        System.out.println(conv.toXQueryString(criteria));
    }
}

