package gr.uoa.di.driver.enabling.islookup.cache;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBException;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.SearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;

public class CachingISLookUp<D extends DriverResource> implements ISLookUp<D> {
	static Logger logger = Logger.getLogger(CachingISLookUp.class);
	
	private Ehcache criteriaCache = null;
	private Ehcache idCache = null;
	private ResourceToXmlConverter<D> converter = null;
	private ServiceLocator<ISLookUpService> lookupLocator = null;

	public D getById(String id) throws ISLookUpException {
		logger.debug("Requested object with id " + id);
		
		String key = id;
		Element element = (Element) idCache.get(key);

		if (element != null)
			return this.parseXml((String) element.getObjectValue());
		else
			return null;
	}

	public List<D> getByid(String[] ids) throws ISLookUpException {
		List<D> list = new ArrayList<D>();

		for (String id : ids)
			list.add(this.getById(id));

		return list;
	}

	@SuppressWarnings("unchecked")
	public List<D> fetch(SearchCriteria criteria) throws ISLookUpException {
		if (logger.isDebugEnabled())
			logger.debug("Fetching results for query: " + 
					converter.toXQueryString(criteria));
		
		CriteriaCacheKey key = new CriteriaCacheKey(criteria);
		key.setXQuery(converter.toXQueryString(criteria));
		
		Element element = criteriaCache.get(key);
		List<String> xmls = (List<String>) element.getObjectValue();

		return this.processSearchResults(xmls);
	}

	private List<D> processSearchResults(List<String> xmls) {
		List<D> result = new ArrayList<D>();

		for (String xml:xmls) {
			D d = this.parseXml(xml);

			this.updateIdCache(d.getResourceId(), xml);

			result.add(d);
		}

		return result;
	}

	private D parseXml(String xml) {
		try {
			return converter.XmlToObject(xml);
		} catch (JAXBException je) {
			logger.error("Error parsing xml profile", je);
			return null;
		}
	}

	private void updateIdCache(String id, String xml) {
		Element e = new Element(id, xml);

		idCache.put(e);
	}

	@SuppressWarnings("unchecked")
	public List<D> performQuickSearch(SearchCriteria criteria)
			throws ISLookUpException {
		if (logger.isDebugEnabled())
			logger.debug("Performing quick search for query: "
					+ converter.toXQueryString(criteria));

		CriteriaCacheKey key = new CriteriaCacheKey(criteria);
		key.setXQuery(converter.toXQueryString(criteria));
		Element element = criteriaCache.get(key);

		return this.processSearchResults( (List<String>) element.getObjectValue());
	}
	
	public List<String> fetch(String XQuery) {
		throw new UnsupportedOperationException();
	}

	public D getUniqueResult(SearchCriteria criteria) throws ISLookUpException {
		if (logger.isDebugEnabled())
			logger.debug("Fetching unique result for query: " + 
					converter.toXQueryString(criteria));
		
		List<D> list = this.performQuickSearch(criteria);

		if (list.size() == 0)
			return null;
		else if (list.size() == 1)
			return list.get(0);
		else
			throw new ISLookUpException("More than one results in query");
	}

	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public void setConverter(ResourceToXmlConverter<D> converter) {
		this.converter = converter;
	}

	public void setCriteriaCache(Ehcache criteriaCache) {
		this.criteriaCache = criteriaCache;
	}

	public void setIdCache(Ehcache idCache) {
		this.idCache = idCache;
	}
}
