/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repos;

import com.unboundid.util.Base64;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repos.RepoApi;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class RepoApiDirectImpl
implements RepoApi {
    private static Logger logger = Logger.getLogger(RepoApiDirectImpl.class);
    private DataSource openAireDataSource = null;

    @Override
    public Repository getRepository(String id) throws Exception {
        return this.getRepository(null, id);
    }

    @Override
    public Repository getRepository(String officialName, String id) throws SQLException {
        Connection conn = null;
        Repository repo = null;
        try {
            logger.info((Object)("getting repository " + officialName + " from openaire db"));
            conn = this.openAireDataSource.getConnection();
            PreparedStatement stm = null;
            PreparedStatement stm1 = null;
            stm = conn.prepareStatement("SELECT * FROM datasources d WHERE d.id = ?");
            stm.setString(1, id);
            ResultSet rs = stm.executeQuery();
            if (rs.next()) {
                repo = new Repository();
                repo.setId(rs.getString("Id"));
                repo.setOfficialName(rs.getString("officialname"));
                repo.setEnglishName(rs.getString("englishname"));
                repo.setWebsiteUrl(rs.getString("websiteurl"));
                repo.setLogoUrl(rs.getString("logourl"));
                repo.setContactEmail(rs.getString("contactemail"));
                repo.setLatitude(Double.valueOf(rs.getDouble("latitude")));
                repo.setLongitude(Double.valueOf(rs.getDouble("longitude")));
                repo.setTimezone(Double.valueOf(rs.getDouble("timezone")));
                repo.setNamespacePrefix(rs.getString("namespaceprefix"));
                repo.setDescription(rs.getString("description"));
                repo.setCollectedFrom(rs.getString("collectedfrom"));
                repo.setActivationId("activationid");
                repo.setTypology(rs.getString("typology"));
                repo.setDatasourceClass(rs.getString("datasourceClass"));
                repo.setProvenanceActionClass(rs.getString("provenanceactionclass"));
                repo.setDateOfCollection((Date)rs.getDate("dateofcollection"));
                repo.setIssn(rs.getString("issn"));
                repo.setEissn(rs.getString("eissn"));
                repo.setLissn(rs.getString("lissn"));
                rs.close();
                stm.close();
                stm = conn.prepareStatement("SELECT * FROM api a WHERE a.datasource = ? ORDER BY id");
                stm.setString(1, repo.getId());
                rs = stm.executeQuery();
                logger.debug((Object)"searching api");
                while (rs.next()) {
                    RepositoryInterface iFace = new RepositoryInterface();
                    if (rs.getBoolean("useedited")) {
                        iFace.setBaseUrl(rs.getString("edited"));
                        iFace.setAccessProtocol(rs.getString("editedprotocolclass"));
                    } else {
                        iFace.setBaseUrl(rs.getString("original"));
                        iFace.setAccessProtocol(rs.getString("originalprotocolclass"));
                    }
                    iFace.setId(rs.getString("id"));
                    String apiId = rs.getString("id");
                    logger.debug((Object)("apiId: " + apiId));
                    stm1 = conn.prepareStatement("SELECT * FROM apicollections ac WHERE ac.api = ?");
                    stm1.setString(1, apiId);
                    ResultSet rs1 = stm1.executeQuery();
                    String setEdited = null;
                    iFace.setAccessSet("none");
                    logger.debug((Object)"searching apicollections");
                    while (rs1.next()) {
                        if (rs1.getString("accessparam").equals("SET")) {
                            iFace.setAccessSet(rs1.getString("accessvalue"));
                            continue;
                        }
                        if (rs1.getString("accessparam").equals("SET_EDITED")) {
                            setEdited = rs1.getString("accessvalue");
                            continue;
                        }
                        if (!rs1.getString("accessparam").equals("FORMAT")) continue;
                        iFace.setAccessFormat(rs1.getString("accessvalue"));
                    }
                    if (setEdited != null) {
                        iFace.setAccessSet(setEdited);
                    }
                    if (iFace.getAccessSet().equalsIgnoreCase("driver")) {
                        iFace.setCompliance("Driver");
                    } else if (iFace.getAccessSet().equalsIgnoreCase("ec_fundedresources")) {
                        iFace.setCompliance("OpenAIRE 2.0");
                    } else if (iFace.getAccessSet().equalsIgnoreCase("openaire")) {
                        iFace.setCompliance("OpenAIRE 3.0");
                    } else if (iFace.getAccessSet().equalsIgnoreCase("openaire_data")) {
                        iFace.setCompliance("OpenAIRE 3.0");
                    } else if (iFace.getAccessSet().equalsIgnoreCase("none")) {
                        iFace.setCompliance("notCompatible");
                    } else {
                        iFace.setCompliance("UNKNOWN");
                    }
                    rs1.close();
                    stm1.close();
                    repo.getInterfaces().add(iFace);
                }
                rs.close();
                stm.close();
                stm = conn.prepareStatement("SELECT o.legalname, o.countryclass FROM datasources d, organizations o, datasource_organization dor WHERE dor.datasource=d.id AND o.id=dor.organization AND d.id = ?");
                stm.setString(1, id);
                rs = stm.executeQuery();
                if (rs.next()) {
                    repo.setOrganization(rs.getString(1));
                    repo.setCountryCode(rs.getString(2));
                }
                rs.close();
                stm.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error getting repo " + officialName + " from openaire db"), (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
        return repo;
    }

    @Override
    public String storeRepository(Repository repo, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        String retMessage = null;
        Connection conn = null;
        try {
            conn = this.openAireDataSource.getConnection();
            PreparedStatement stm = null;
            ResultSet rs = null;
            logger.info((Object)("storing " + datatype + " repository.."));
            if (datatype.equalsIgnoreCase("opendoar")) {
                logger.debug((Object)"updating datasources values..");
                stm = conn.prepareStatement("UPDATE datasources SET englishname = ?, logourl = ?, timezone = ?, optional1 = ?, activationid = ?, contactemail = ? WHERE id = ?");
                stm.setString(1, repo.getEnglishName());
                stm.setString(2, repo.getLogoUrl());
                stm.setDouble(3, repo.getTimezone());
                stm.setString(4, repo.getRegisteredBy());
                stm.setString(5, repo.getActivationId());
                stm.setString(6, repo.getContactEmail());
                stm.setString(7, repo.getId());
                if (stm.executeUpdate() > 0) {
                    logger.debug((Object)"finished updating values in datasources..");
                    stm.close();
                    conn.commit();
                }
                logger.debug((Object)"checking current values in api..");
                stm = conn.prepareStatement("SELECT COUNT(*) FROM api WHERE datasource = ?");
                stm.setString(1, repo.getId());
                rs = stm.executeQuery();
                int noCurrentInApi = 0;
                if (rs.next()) {
                    noCurrentInApi = rs.getInt(1);
                }
                stm.close();
                rs.close();
                for (RepositoryInterface iFace : repo.getInterfaces()) {
                    logger.debug((Object)("checking if interface : " + iFace.getId() + " already exists in api.."));
                    stm = conn.prepareStatement("SELECT * FROM api WHERE datasource = ? AND id = ?");
                    stm.setString(1, repo.getId());
                    stm.setString(2, iFace.getId());
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        logger.debug((Object)"not exist..");
                        stm.close();
                        rs.close();
                        stm = conn.prepareStatement("INSERT INTO api (id, typology, originalprotocolclass, original, datasource, _dnet_resource_identifier_)  VALUES (?,?,?,?,?,?)");
                        iFace.setId("api_________::" + repo.getId() + "::" + noCurrentInApi);
                        logger.debug((Object)("creating new api_id: " + iFace.getId()));
                        ++noCurrentInApi;
                        String apiTypology = "UNKNOWN";
                        if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire3.0") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0_data") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0")) {
                            apiTypology = "openaire";
                        } else if (iFace.getDesiredCompatibilityLevel().contains("driver")) {
                            apiTypology = "driver";
                        }
                        stm.setString(1, iFace.getId());
                        stm.setString(2, apiTypology);
                        stm.setString(3, iFace.getAccessProtocol());
                        stm.setString(4, iFace.getBaseUrl());
                        stm.setString(5, repo.getId());
                        stm.setString(6, iFace.getId());
                        if (stm.executeUpdate() > 0) {
                            logger.debug((Object)(iFace.getId() + " inserted in api.."));
                            logger.debug((Object)"now inserting in apicollections..");
                            stm.close();
                            rs.close();
                            conn.commit();
                            stm = conn.prepareStatement("INSERT INTO apicollections (accessparam, accessvalue, api, _dnet_resource_identifier_)  VALUES (?,?,?,?)");
                            stm.setString(1, "FORMAT");
                            stm.setString(2, iFace.getAccessFormat());
                            stm.setString(3, iFace.getId());
                            stm.setString(4, "FORMAT@@" + iFace.getAccessFormat() + "@@" + iFace.getId());
                            stm.addBatch();
                            stm.setString(1, "SET");
                            stm.setString(2, iFace.getAccessSet());
                            stm.setString(3, iFace.getId());
                            stm.setString(4, "SET@@" + iFace.getAccessSet() + "@@" + iFace.getId());
                            stm.addBatch();
                            if (stm.executeBatch()[0] > 0) {
                                logger.debug((Object)(iFace.getId() + " inserted in apicollections."));
                            }
                            logger.debug((Object)"finished updating set + format values in apicollections.");
                            stm.close();
                            conn.commit();
                        }
                    } else {
                        logger.debug((Object)"exists..");
                        boolean edited = false;
                        if (rs.getString("original") == null || rs.getString("originalprotocolclass") == null || !rs.getString("original").equalsIgnoreCase(iFace.getBaseUrl()) || !rs.getString("originalprotocolclass").equalsIgnoreCase(iFace.getAccessProtocol())) {
                            edited = true;
                        }
                        logger.debug((Object)"updating edited values in api..");
                        stm.close();
                        rs.close();
                        String apiTypology = "UNKNOWN";
                        if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire3.0") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0")) {
                            apiTypology = "openaire";
                        } else if (iFace.getDesiredCompatibilityLevel().contains("driver")) {
                            apiTypology = "driver";
                        }
                        stm = conn.prepareStatement("UPDATE api SET typology = ?, edited = ?, editedprotocolclass = ?, useedited = ?  WHERE datasource = ? AND id = ? ");
                        stm.setString(1, apiTypology);
                        if (edited) {
                            stm.setString(2, iFace.getBaseUrl());
                            stm.setString(3, iFace.getAccessProtocol());
                            stm.setBoolean(4, true);
                        } else {
                            stm.setString(2, null);
                            stm.setString(3, null);
                            stm.setBoolean(4, false);
                        }
                        stm.setString(5, repo.getId());
                        stm.setString(6, iFace.getId());
                        if (stm.executeUpdate() > 0) {
                            logger.debug((Object)"finished updating values in api..");
                            stm.close();
                            conn.commit();
                        }
                        logger.debug((Object)"updating apicollections..");
                        logger.debug((Object)"deleting current values from apicollections..");
                        stm = conn.prepareStatement("DELETE FROM apicollections WHERE api = ?");
                        stm.setString(1, iFace.getId());
                        if (stm.executeUpdate() > 0) {
                            logger.debug((Object)("values for interface " + iFace.getId() + " deleted from api_collections.."));
                            stm.close();
                            rs.close();
                            conn.commit();
                        }
                        logger.debug((Object)"now inserting in apicollections..");
                        stm = conn.prepareStatement("INSERT INTO apicollections (accessparam, accessvalue, api, _dnet_resource_identifier_)  VALUES (?,?,?,?)");
                        stm.setString(1, "FORMAT");
                        stm.setString(2, iFace.getAccessFormat());
                        stm.setString(3, iFace.getId());
                        stm.setString(4, "FORMAT@@" + iFace.getAccessFormat() + "@@" + iFace.getId());
                        stm.addBatch();
                        stm.setString(1, "SET");
                        stm.setString(2, iFace.getAccessSet());
                        stm.setString(3, iFace.getId());
                        stm.setString(4, "SET@@" + iFace.getAccessSet() + "@@" + iFace.getId());
                        stm.addBatch();
                        if (stm.executeBatch()[0] > 0) {
                            logger.debug((Object)(iFace.getId() + " inserted in apicollections."));
                        }
                        logger.debug((Object)"finished updating set + format values in apicollections.");
                        stm.close();
                        conn.commit();
                    }
                    logger.debug((Object)("interface : " + iFace.getId() + " inserted successfully.."));
                }
            } else if (datatype.equalsIgnoreCase("journal") || datatype.equalsIgnoreCase("aggregator")) {
                logger.debug((Object)("looking if " + datatype + " " + repo.getOfficialName() + " is already in datasources"));
                stm = conn.prepareStatement("SELECT * FROM datasources WHERE officialname = ? OR id = ?");
                stm.setString(1, repo.getOfficialName());
                stm.setString(2, repo.getId());
                rs = stm.executeQuery();
                if (rs.next()) {
                    retMessage = datatype + " " + repo.getOfficialName() + " is already in datasources.";
                    logger.debug((Object)retMessage);
                    stm.close();
                    rs.close();
                } else {
                    logger.debug((Object)(datatype + " " + repo.getOfficialName() + " is not in datasources. Inserting.."));
                    stm = conn.prepareStatement("INSERT INTO datasources(id, officialname, englishname, websiteurl, logourl, contactemail, latitude, longitude, timezone, namespaceprefix, collectedfrom, activationid, typology, datasourceclass, provenanceactionclass, _dnet_resource_identifier_, optional1, issn, eissn, lissn, description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    stm.setString(1, repo.getId());
                    stm.setString(2, repo.getOfficialName());
                    stm.setString(3, repo.getEnglishName());
                    stm.setString(4, repo.getWebsiteUrl());
                    stm.setString(5, repo.getLogoUrl());
                    stm.setString(6, repo.getContactEmail());
                    stm.setDouble(7, repo.getLatitude());
                    stm.setDouble(8, repo.getLongitude());
                    stm.setString(9, repo.getTimezone() + "");
                    stm.setString(10, repo.getNamespacePrefix());
                    stm.setString(11, repo.getCollectedFrom());
                    stm.setString(12, repo.getActivationId());
                    stm.setString(13, repo.getTypology());
                    stm.setString(14, repo.getDatasourceClass());
                    stm.setString(15, repo.getProvenanceActionClass());
                    stm.setString(16, repo.getId());
                    stm.setString(17, repo.getRegisteredBy());
                    stm.setString(18, repo.getIssn());
                    stm.setString(19, repo.getEissn());
                    stm.setString(20, repo.getLissn());
                    stm.setString(21, repo.getDescription());
                    if (stm.executeUpdate() > 0) {
                        logger.debug((Object)(datatype + " " + repo.getOfficialName() + " inserted in datasources."));
                        logger.debug((Object)"inserting in api..");
                        stm.close();
                        conn.commit();
                        int noCurrentInApi = 0;
                        for (RepositoryInterface iFace : repo.getInterfaces()) {
                            stm = conn.prepareStatement("INSERT INTO api (id, typology, originalprotocolclass, original, datasource, _dnet_resource_identifier_)  VALUES (?,?,?,?,?,?)");
                            iFace.setId("api_________::" + repo.getId() + "::" + noCurrentInApi);
                            logger.debug((Object)("creating new api_id: " + iFace.getId()));
                            ++noCurrentInApi;
                            String apiTypology = "UNKNOWN";
                            if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire3.0") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0")) {
                                apiTypology = "openaire";
                            } else if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("driver")) {
                                apiTypology = "driver";
                            }
                            stm.setString(1, iFace.getId());
                            stm.setString(2, apiTypology);
                            stm.setString(3, iFace.getAccessProtocol());
                            stm.setString(4, iFace.getBaseUrl());
                            stm.setString(5, repo.getId());
                            stm.setString(6, iFace.getId());
                            if (stm.executeUpdate() > 0) {
                                logger.debug((Object)(iFace.getId() + " inserted in api.."));
                                logger.debug((Object)"now inserting in apicollections..");
                                stm.close();
                                rs.close();
                                conn.commit();
                                stm = conn.prepareStatement("INSERT INTO apicollections (accessparam, accessvalue, api, _dnet_resource_identifier_)  VALUES (?,?,?,?)");
                                stm.setString(1, "FORMAT");
                                stm.setString(2, iFace.getAccessFormat());
                                stm.setString(3, iFace.getId());
                                stm.setString(4, "FORMAT@@" + iFace.getAccessFormat() + "@@" + iFace.getId());
                                stm.addBatch();
                                stm.setString(1, "SET");
                                stm.setString(2, iFace.getAccessSet());
                                stm.setString(3, iFace.getId());
                                stm.setString(4, "SET@@" + iFace.getAccessSet() + "@@" + iFace.getId());
                                stm.addBatch();
                                if (stm.executeBatch()[0] > 0) {
                                    logger.debug((Object)(iFace.getId() + " inserted in apicollections."));
                                }
                                logger.debug((Object)"finished updating set + format values in apicollections.");
                                stm.close();
                                conn.commit();
                            }
                            logger.debug((Object)("interface : " + iFace.getId() + " inserted successfully.."));
                        }
                        logger.debug((Object)"inserting in organizations..");
                        stm = conn.prepareStatement("SELECT * FROM organizations WHERE id = ?");
                        stm.setString(1, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                        ResultSet rs1 = stm.executeQuery();
                        boolean exists = rs1.next();
                        rs1.close();
                        if (!exists) {
                            if (repo.getCountryCode() == null) {
                                repo.setCountryCode("UNKNOWN");
                            }
                            stm = conn.prepareStatement("INSERT INTO organizations (legalname, countryclass, id, legalshortname, collectedfrom, provenanceactionclass, _dnet_resource_identifier_) VALUES (?,?,?,?,?,?,?)");
                            stm.setString(1, repo.getOrganization());
                            stm.setString(2, repo.getCountryCode());
                            stm.setString(3, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                            stm.setString(4, repo.getOrganization());
                            stm.setString(5, repo.getCollectedFrom());
                            stm.setString(6, repo.getProvenanceActionClass());
                            stm.setString(7, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                            stm.executeUpdate();
                            logger.debug((Object)("organization openaire____::" + Base64.encode((String)repo.getOrganization()) + " inserted in organizations."));
                            stm.close();
                            conn.commit();
                        } else {
                            logger.debug((Object)("Organization " + repo.getOrganization() + " already exists"));
                        }
                        logger.debug((Object)"inserting in datasource-organizations..");
                        stm = conn.prepareStatement("INSERT INTO datasource_organization (organization, datasource, _dnet_resource_identifier_) VALUES (?,?,?)");
                        stm.setString(1, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                        stm.setString(2, repo.getId());
                        stm.setString(3, repo.getId() + "@@openaire____::" + Base64.encode((String)repo.getOrganization()));
                        if (stm.executeUpdate() > 0) {
                            logger.debug((Object)("organizationopenaire____::" + Base64.encode((String)repo.getOrganization()) + " inserted in datasource-organizations."));
                            stm.close();
                            conn.commit();
                        }
                    }
                    logger.debug((Object)("Finished storing " + datatype + " repository.."));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Error storing repo " + repo.getOfficialName() + " in openaire db"), (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
        return retMessage;
    }

    @Override
    public TreeMap<String, List<Map<String, String>>> getRepositoriesByCountry(String collectedFrom) throws SQLException {
        Connection conn = null;
        TreeMap<String, List<Map<String, String>>> res = new TreeMap<String, List<Map<String, String>>>();
        try {
            logger.info((Object)"getting repos by country from openaire db");
            String collFrom = null;
            if (collectedFrom.equalsIgnoreCase("opendoar")) {
                logger.debug((Object)"populating doar list");
                collFrom = "openaire____::opendoar";
            } else if (collectedFrom.equalsIgnoreCase("re3data")) {
                logger.debug((Object)"populating re3data list");
                collFrom = "openaire____::re3data";
            }
            conn = this.openAireDataSource.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT DISTINCT d.id, d.officialname, c.name, d.websitEurl FROM datasources d, organizations o, datasource_organization dor, class c WHERE dor.datasource=d.id AND o.id=dor.organization AND o.countryclass=c.code AND d.collectedfrom=? ORDER BY c.name, d.officialname");
            ps.setString(1, collFrom);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String country = rs.getString(3);
                List<Map<String, String>> repos = res.get(country);
                if (repos == null) {
                    repos = new ArrayList<Map<String, String>>();
                    res.put(country, repos);
                }
                HashMap<String, String> repo = new HashMap<String, String>();
                repo.put("name", rs.getString(2));
                repo.put("url", rs.getString(4));
                repo.put("id", rs.getString(1));
                repos.add(repo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error getting repositories from openaire db", (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
        return res;
    }

    @Override
    public Map<String, List<Repository>> getRepositoriesPerCountry(String collectedFrom) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Repository> getRepositoriesOfCountry(String collectedFrom, String country) throws Exception {
        throw new UnsupportedOperationException();
    }

    public DataSource getOpenAireDataSource() {
        return this.openAireDataSource;
    }

    public void setOpenAireDataSource(DataSource openAireDataSource) {
        this.openAireDataSource = openAireDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Repository> getRepositoriesOfUser(String user_mail, Boolean repoAdmin) throws SQLException {
        Connection conn = null;
        Repository repo = null;
        ArrayList<Repository> retRepos = new ArrayList<Repository>();
        try {
            logger.info((Object)("getting repositories registered by user: " + user_mail + " from openaire db"));
            conn = this.openAireDataSource.getConnection();
            PreparedStatement stm = conn.prepareStatement("SELECT * FROM datasources d WHERE contactemail = ? OR optional1 = ?");
            stm.setString(1, user_mail);
            stm.setString(2, user_mail);
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                repo = new Repository();
                repo.setId(rs.getString("id"));
                repo.setOfficialName(rs.getString("officialname"));
                retRepos.add(repo);
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            logger.error((Object)("error getting repositories registered by user: " + user_mail + " from openaire db"), (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"could not close openaire db connection", (Throwable)e);
            }
        }
        return retRepos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUrlsOfRepos(String user_mail, Boolean repoAdmin) throws SQLException {
        Connection conn = null;
        ArrayList<String> urls = new ArrayList<String>();
        try {
            logger.info((Object)("getting url from repositories registered by user: " + user_mail + " from openaire db"));
            conn = this.openAireDataSource.getConnection();
            PreparedStatement stm = conn.prepareStatement("SELECT a.original, a.edited FROM datasources d, api a WHERE a.datasource=d.id AND ( d.optional1=? OR d.contactemail=?)");
            stm.setString(1, user_mail);
            stm.setString(2, user_mail);
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                if (rs.getString(1) != null && !rs.getString(1).isEmpty() && !urls.contains(rs.getString(1))) {
                    urls.add(rs.getString(1));
                }
                if (rs.getString(2) == null || rs.getString(2).isEmpty() || urls.contains(rs.getString(2))) continue;
                urls.add(rs.getString(2));
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            logger.error((Object)("error getting url from repositories registered by user: " + user_mail + " from openaire db"), (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"could not close openaire db connection", (Throwable)e);
            }
        }
        return urls;
    }

    @Override
    public boolean insertPubFileInterface(String dsId, RepositoryInterface iFace) throws Exception {
        return false;
    }

    @Override
    public boolean updatePubFileInterface(String dsId, RepositoryInterface iFace) throws Exception {
        return false;
    }

    @Override
    public Map<String, Repository> getRepositoriesAsMap(String collectedFrom) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Repository> getRepositories(String collectedFrom) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNextScheduledExecution(String mode) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getListLatestUpdate(String mode) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Repository> getReposByIds(List<String> datasourceIds) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getRepositoryStats(Repository repo) throws Exception {
    }

    @Override
    public String updateRepositoryInformation(Repository repo) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String deleteRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteRepositoryInterfacesWithoutChecks(String dsId, List<RepositoryInterface> interfaces, String datatype) throws Exception {
    }

    @Override
    public String updateRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces, List<RepositoryInterface> interfacesOld, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositoryInterface updateRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String insertRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces, List<RepositoryInterface> interfacesOld, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositoryInterface insertRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean unregisterRepository(Repository repo) throws Exception {
        return false;
    }

    @Override
    public List<Map<String, String>> getRegisteredReposByOthers(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Map<String, String>> getRepositoriesOfUser(String user_mail) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean repoIsCompliant(String officialName) throws SQLException {
        boolean retCompliant = false;
        Connection conn = null;
        try {
            logger.info((Object)("checking if " + officialName + " is openaire compliant"));
            conn = this.openAireDataSource.getConnection();
            PreparedStatement stm = conn.prepareStatement("SELECT openairecompatibilityclass FROM datasources WHERE officialname = ?");
            stm.setString(1, officialName);
            ResultSet rs = stm.executeQuery();
            if (rs.next()) {
                retCompliant = !rs.getString(1).equals("UNKNOWN") && !rs.getString(1).equals("notCompatible");
            }
            stm.close();
            rs.close();
            logger.debug((Object)(officialName + " is openaire compliant"));
        }
        catch (Exception e) {
            logger.error((Object)("error connecting to openaire db to get openairecompliant for " + officialName), (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"could not close openaire db connection", (Throwable)e);
            }
        }
        return retCompliant;
    }

    @Override
    public Map<String, String> getRepoCompatibility(String officialName, String datasourceId) throws Exception {
        HashMap<String, String> compMap = null;
        Connection conn = null;
        try {
            logger.info((Object)("getting repository " + officialName + " compatibility from openaire db"));
            conn = this.openAireDataSource.getConnection();
            PreparedStatement stm = null;
            stm = conn.prepareStatement("SELECT openairecompatibilityclass FROM datasources d WHERE d.id = ?");
            stm.setString(1, datasourceId);
            ResultSet rs = stm.executeQuery();
            compMap = new HashMap<String, String>();
            if (rs.next()) {
                String[] comp;
                for (String c : comp = rs.getString("openairecompatibilityclass").split("-")) {
                    if (c.equalsIgnoreCase("driver")) {
                        compMap.put("driver", "driver");
                        continue;
                    }
                    if (c.equalsIgnoreCase("openaire2.0")) {
                        compMap.put("openaire2.0", "ec_fundedresources");
                        compMap.put("openaire2.0_data", "openaire_data");
                        continue;
                    }
                    if (c.equalsIgnoreCase("openaire3.0")) {
                        compMap.put("openaire3.0", "openaire");
                        continue;
                    }
                    if (c.equalsIgnoreCase("notCompatible")) {
                        compMap.put("notCompatible", "notCompatible");
                        continue;
                    }
                    if (!c.equalsIgnoreCase("UNKNOWN")) continue;
                    compMap.put("UNKNOWN", "UNKNOWN");
                }
            }
            rs.close();
            stm.close();
        }
        catch (SQLException e) {
            logger.error((Object)("Error getting repo " + officialName + " compatibility from openaire db"), (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
        return compMap;
    }

    @Override
    public String editRepository(Repository repo, String officialNameOld, String idOld, String datatype) throws Exception {
        String retMessage = null;
        Connection conn = this.openAireDataSource.getConnection();
        PreparedStatement stm = null;
        ResultSet rs = null;
        logger.info((Object)("editing " + datatype + " repository.."));
        if (datatype.equalsIgnoreCase("opendoar")) {
            logger.debug((Object)("updating datasources values for id:" + repo.getId() + " + name:" + repo.getOfficialName()));
            stm = conn.prepareStatement("UPDATE datasources SET englishname = ?, logourl = ?, timezone = ? WHERE officialname = ? AND id = ?");
            stm.setString(1, repo.getEnglishName());
            stm.setString(2, repo.getLogoUrl());
            stm.setDouble(3, repo.getTimezone());
            stm.setString(4, repo.getOfficialName());
            stm.setString(5, repo.getId());
            if (stm.executeUpdate() > 0) {
                logger.debug((Object)"finished updating values in datasources..");
                stm.close();
                conn.commit();
            }
            logger.debug((Object)"checking current values in api..");
            stm = conn.prepareStatement("SELECT COUNT(*) FROM api WHERE datasource = ?");
            stm.setString(1, repo.getId());
            rs = stm.executeQuery();
            int noCurrentInApi = 0;
            if (rs.next()) {
                noCurrentInApi = rs.getInt(1);
            }
            stm.close();
            rs.close();
            for (RepositoryInterface iFace : repo.getInterfaces()) {
                logger.debug((Object)("checking if interface : " + iFace.getId() + " already exists in api.."));
                stm = conn.prepareStatement("SELECT * FROM api WHERE datasource = ? AND id = ?");
                stm.setString(1, repo.getId());
                stm.setString(2, iFace.getId());
                rs = stm.executeQuery();
                if (!rs.next()) {
                    logger.debug((Object)"not exist..");
                    stm.close();
                    rs.close();
                    stm = conn.prepareStatement("INSERT INTO api (id, typology, originalprotocolclass, original, datasource, _dnet_resource_identifier_)  VALUES (?,?,?,?,?,?)");
                    iFace.setId("api_________::" + repo.getId() + "::" + noCurrentInApi);
                    logger.debug((Object)("creating new api_id: " + iFace.getId()));
                    ++noCurrentInApi;
                    String apiTypology = "UNKNOWN";
                    if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire3.0") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0")) {
                        apiTypology = "openaire";
                    } else if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("driver")) {
                        apiTypology = "driver";
                    }
                    stm.setString(1, iFace.getId());
                    stm.setString(2, apiTypology);
                    stm.setString(3, iFace.getAccessProtocol());
                    stm.setString(4, iFace.getBaseUrl());
                    stm.setString(5, repo.getId());
                    stm.setString(6, iFace.getId());
                    if (stm.executeUpdate() > 0) {
                        logger.debug((Object)(iFace.getId() + " inserted in api.."));
                        logger.debug((Object)"now inserting in apicollections..");
                        stm.close();
                        rs.close();
                        conn.commit();
                        stm = conn.prepareStatement("INSERT INTO apicollections (accessparam, accessvalue, api, _dnet_resource_identifier_)  VALUES (?,?,?,?)");
                        stm.setString(1, "FORMAT");
                        stm.setString(2, iFace.getAccessFormat());
                        stm.setString(3, iFace.getId());
                        stm.setString(4, "FORMAT@@" + iFace.getAccessFormat() + "@@" + iFace.getId());
                        stm.addBatch();
                        stm.setString(1, "SET");
                        stm.setString(2, iFace.getAccessSet());
                        stm.setString(3, iFace.getId());
                        stm.setString(4, "SET@@" + iFace.getAccessSet() + "@@" + iFace.getId());
                        stm.addBatch();
                        if (stm.executeBatch()[0] > 0) {
                            logger.debug((Object)(iFace.getId() + " inserted in apicollections."));
                        }
                        logger.debug((Object)"finished updating set + format values in apicollections.");
                        stm.close();
                        conn.commit();
                    }
                } else {
                    logger.debug((Object)"exists..");
                    boolean edited = false;
                    if (rs.getString("original") == null || rs.getString("originalprotocolclass") == null || !rs.getString("original").equalsIgnoreCase(iFace.getBaseUrl()) || !rs.getString("originalprotocolclass").equalsIgnoreCase(iFace.getAccessProtocol())) {
                        edited = true;
                    }
                    logger.debug((Object)"updating edited values in api..");
                    stm.close();
                    rs.close();
                    String apiTypology = "UNKNOWN";
                    if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire3.0") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0")) {
                        apiTypology = "openaire";
                    } else if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("driver")) {
                        apiTypology = "driver";
                    }
                    stm = conn.prepareStatement("UPDATE api SET typology = ?, edited = ?, editedprotocolclass = ?, useedited = ?  WHERE datasource = ? AND id = ? ");
                    stm.setString(1, apiTypology);
                    if (edited) {
                        stm.setString(2, iFace.getBaseUrl());
                        stm.setString(3, iFace.getAccessProtocol());
                        stm.setBoolean(4, true);
                    } else {
                        stm.setString(2, null);
                        stm.setString(3, null);
                        stm.setBoolean(4, false);
                    }
                    stm.setString(5, repo.getId());
                    stm.setString(6, iFace.getId());
                    if (stm.executeUpdate() > 0) {
                        logger.debug((Object)"finished updating values in api..");
                        stm.close();
                        conn.commit();
                    }
                    logger.debug((Object)"updating apicollections..");
                    logger.debug((Object)"deleting current values from apicollections..");
                    stm = conn.prepareStatement("DELETE FROM apicollections WHERE api = ?");
                    stm.setString(1, iFace.getId());
                    if (stm.executeUpdate() > 0) {
                        logger.debug((Object)("values for interface " + iFace.getId() + " deleted from api_collections.."));
                        stm.close();
                        rs.close();
                        conn.commit();
                    }
                    logger.debug((Object)"now inserting in apicollections..");
                    stm = conn.prepareStatement("INSERT INTO apicollections (accessparam, accessvalue, api, _dnet_resource_identifier_)  VALUES (?,?,?,?)");
                    stm.setString(1, "FORMAT");
                    stm.setString(2, iFace.getAccessFormat());
                    stm.setString(3, iFace.getId());
                    stm.setString(4, "FORMAT@@" + iFace.getAccessFormat() + "@@" + iFace.getId());
                    stm.addBatch();
                    stm.setString(1, "SET");
                    stm.setString(2, iFace.getAccessSet());
                    stm.setString(3, iFace.getId());
                    stm.setString(4, "SET@@" + iFace.getAccessSet() + "@@" + iFace.getId());
                    stm.addBatch();
                    if (stm.executeBatch()[0] > 0) {
                        logger.debug((Object)(iFace.getId() + " inserted in apicollections."));
                    }
                    logger.debug((Object)"finished updating set + format values in apicollections.");
                    stm.close();
                    conn.commit();
                }
                logger.debug((Object)("interface : " + iFace.getId() + " inserted successfully.."));
            }
        } else if (datatype.equalsIgnoreCase("journal") || datatype.equalsIgnoreCase("aggregator")) {
            try {
                stm = conn.prepareStatement("UPDATE datasources SET id = ?, officialname = ?, englishname = ?, websiteurl = ?, logourl = ?, contactemail = ?, latitude = ?, longitude = ?, timezone = ?, namespaceprefix = ?, collectedfrom = ?, typology = ?, datasourceclass = ?, provenanceactionclass = ?, _dnet_resource_identifier_ = ? WHERE officialname = ? AND id = ?");
                stm.setString(1, repo.getId());
                stm.setString(2, repo.getOfficialName());
                stm.setString(3, repo.getEnglishName());
                stm.setString(4, repo.getWebsiteUrl());
                stm.setString(5, repo.getLogoUrl());
                stm.setString(6, repo.getContactEmail());
                stm.setDouble(7, repo.getLatitude());
                stm.setDouble(8, repo.getLongitude());
                stm.setString(9, repo.getTimezone() + "");
                stm.setString(10, repo.getNamespacePrefix());
                stm.setString(11, repo.getCollectedFrom());
                stm.setString(12, repo.getTypology());
                stm.setString(13, repo.getDatasourceClass());
                stm.setString(14, repo.getProvenanceActionClass());
                stm.setString(15, repo.getId());
                stm.setString(16, officialNameOld);
                stm.setString(17, idOld);
                stm.executeUpdate();
                logger.debug((Object)(datatype + " " + repo.getOfficialName() + " inserted in datasources."));
                stm.close();
                conn.commit();
                logger.debug((Object)"checking current values in api..");
                stm = conn.prepareStatement("SELECT COUNT(*) FROM api WHERE datasource = ?");
                stm.setString(1, repo.getId());
                rs = stm.executeQuery();
                int noCurrentInApi = 0;
                if (rs.next()) {
                    noCurrentInApi = rs.getInt(1);
                }
                stm.close();
                rs.close();
                for (RepositoryInterface iFace : repo.getInterfaces()) {
                    logger.debug((Object)("checking if interface : " + iFace.getId() + " already exists in api.."));
                    stm = conn.prepareStatement("SELECT * FROM api WHERE datasource = ? AND id = ?");
                    stm.setString(1, repo.getId());
                    stm.setString(2, iFace.getId());
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        logger.debug((Object)"not exist..");
                        stm.close();
                        rs.close();
                        stm = conn.prepareStatement("INSERT INTO api (id, typology, originalprotocolclass, original, datasource, _dnet_resource_identifier_)  VALUES (?,?,?,?,?,?)");
                        iFace.setId("api_________::" + repo.getId() + "::" + noCurrentInApi);
                        logger.debug((Object)("creating new api_id: " + iFace.getId()));
                        ++noCurrentInApi;
                        String apiTypology = "UNKNOWN";
                        if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire3.0") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0")) {
                            apiTypology = "openaire";
                        } else if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("driver")) {
                            apiTypology = "driver";
                        }
                        stm.setString(1, iFace.getId());
                        stm.setString(2, apiTypology);
                        stm.setString(3, iFace.getAccessProtocol());
                        stm.setString(4, iFace.getBaseUrl());
                        stm.setString(5, repo.getId());
                        stm.setString(6, iFace.getId());
                        if (stm.executeUpdate() > 0) {
                            logger.debug((Object)(iFace.getId() + " inserted in api.."));
                            logger.debug((Object)"now inserting in apicollections..");
                            stm.close();
                            rs.close();
                            conn.commit();
                            stm = conn.prepareStatement("INSERT INTO apicollections (accessparam, accessvalue, api, _dnet_resource_identifier_)  VALUES (?,?,?,?)");
                            stm.setString(1, "FORMAT");
                            stm.setString(2, iFace.getAccessFormat());
                            stm.setString(3, iFace.getId());
                            stm.setString(4, "FORMAT@@" + iFace.getAccessFormat() + "@@" + iFace.getId());
                            stm.addBatch();
                            stm.setString(1, "SET");
                            stm.setString(2, iFace.getAccessSet());
                            stm.setString(3, iFace.getId());
                            stm.setString(4, "SET@@" + iFace.getAccessSet() + "@@" + iFace.getId());
                            stm.addBatch();
                            if (stm.executeBatch()[0] > 0) {
                                logger.debug((Object)(iFace.getId() + " inserted in apicollections."));
                            }
                            logger.debug((Object)"finished updating set + format values in apicollections.");
                            stm.close();
                            conn.commit();
                        }
                    } else {
                        logger.debug((Object)"exists..");
                        boolean edited = false;
                        if (rs.getString("original") == null || rs.getString("originalprotocolclass") == null || !rs.getString("original").equalsIgnoreCase(iFace.getBaseUrl()) || !rs.getString("originalprotocolclass").equalsIgnoreCase(iFace.getAccessProtocol())) {
                            edited = true;
                        }
                        logger.debug((Object)"updating edited values in api..");
                        stm.close();
                        rs.close();
                        String apiTypology = "UNKNOWN";
                        if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire3.0") || iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("openaire2.0")) {
                            apiTypology = "openaire";
                        } else if (iFace.getDesiredCompatibilityLevel().equalsIgnoreCase("driver")) {
                            apiTypology = "driver";
                        }
                        stm = conn.prepareStatement("UPDATE api SET typology = ?, edited = ?, editedprotocolclass = ?, useedited = ?  WHERE datasource = ? AND id = ? ");
                        stm.setString(1, apiTypology);
                        if (edited) {
                            stm.setString(2, iFace.getBaseUrl());
                            stm.setString(3, iFace.getAccessProtocol());
                            stm.setBoolean(4, true);
                        } else {
                            stm.setString(2, null);
                            stm.setString(3, null);
                            stm.setBoolean(4, false);
                        }
                        stm.setString(5, repo.getId());
                        stm.setString(6, iFace.getId());
                        if (stm.executeUpdate() > 0) {
                            logger.debug((Object)"finished updating values in api..");
                            stm.close();
                            conn.commit();
                        }
                        logger.debug((Object)"updating apicollections..");
                        logger.debug((Object)"deleting current values from apicollections..");
                        stm = conn.prepareStatement("DELETE FROM apicollections WHERE api = ?");
                        stm.setString(1, iFace.getId());
                        if (stm.executeUpdate() > 0) {
                            logger.debug((Object)("values for interface " + iFace.getId() + " deleted from api_collections.."));
                            stm.close();
                            rs.close();
                            conn.commit();
                        }
                        logger.debug((Object)"now inserting in apicollections..");
                        stm = conn.prepareStatement("INSERT INTO apicollections (accessparam, accessvalue, api, _dnet_resource_identifier_)  VALUES (?,?,?,?)");
                        stm.setString(1, "FORMAT");
                        stm.setString(2, iFace.getAccessFormat());
                        stm.setString(3, iFace.getId());
                        stm.setString(4, "FORMAT@@" + iFace.getAccessFormat() + "@@" + iFace.getId());
                        stm.addBatch();
                        stm.setString(1, "SET");
                        stm.setString(2, iFace.getAccessSet());
                        stm.setString(3, iFace.getId());
                        stm.setString(4, "SET@@" + iFace.getAccessSet() + "@@" + iFace.getId());
                        stm.addBatch();
                        if (stm.executeBatch()[0] > 0) {
                            logger.debug((Object)(iFace.getId() + " inserted in apicollections."));
                        }
                        logger.debug((Object)"finished updating set + format values in apicollections.");
                        stm.close();
                        conn.commit();
                    }
                    logger.debug((Object)("interface : " + iFace.getId() + " inserted successfully.."));
                }
                logger.debug((Object)"inserting in organizations..");
                stm.close();
                conn.commit();
                stm = conn.prepareStatement("SELECT * FROM organizations WHERE id = ?");
                stm.setString(1, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                ResultSet rs1 = stm.executeQuery();
                boolean exists = rs1.next();
                rs1.close();
                if (!exists) {
                    stm = conn.prepareStatement("SELECT code FROM class WHERE name = ?");
                    stm.setString(1, repo.getCountryName());
                    rs1 = stm.executeQuery();
                    String countryCode = "UNKNOWN";
                    if (rs1.next()) {
                        countryCode = rs1.getString(1);
                        stm.close();
                    }
                    stm = conn.prepareStatement("INSERT INTO organizations (legalname, countryclass, id, legalshortname, _dnet_resource_identifier_) VALUES (?,?,?,?,?)");
                    stm.setString(1, repo.getOrganization());
                    stm.setString(2, countryCode);
                    stm.setString(3, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                    stm.setString(4, repo.getOrganization());
                    stm.setString(5, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                    stm.executeUpdate();
                    logger.debug((Object)("organizationopenaire____::" + Base64.encode((String)repo.getOrganization()) + " inserted in organizations."));
                    stm.close();
                    conn.commit();
                } else {
                    logger.debug((Object)("Organization " + repo.getOrganization() + " already exists"));
                }
                logger.debug((Object)"inserting in datasource-organizations..");
                stm = conn.prepareStatement("UPDATE datasource_organization SET organization = ? , datasource = ? , _dnet_resource_identifier_ = ? WHERE datasource = ? ");
                stm.setString(1, "openaire____::" + Base64.encode((String)repo.getOrganization()));
                stm.setString(2, repo.getId());
                stm.setString(3, repo.getId() + "@@openaire____::" + Base64.encode((String)repo.getOrganization()));
                stm.setString(4, idOld);
                if (stm.executeUpdate() > 0) {
                    logger.debug((Object)("organizationopenaire____::" + Base64.encode((String)repo.getOrganization()) + " inserted in datasource-organizations."));
                    stm.close();
                    conn.commit();
                }
                logger.debug((Object)("Finished updating " + datatype + " repository.."));
            }
            catch (SQLException e) {
                logger.error((Object)("Error updating repo " + repo.getOfficialName() + " from openaire db"), (Throwable)e);
                throw e;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Error closing connection", (Throwable)e);
                    }
                }
            }
        }
        return retMessage;
    }

    @Override
    public boolean updateRepositoryInterfaceCompliance(String officialName, String datasourceId, String interfaceId, String compliance, String set, String baseUrl, String oldId) throws Exception {
        boolean ret = true;
        Connection conn = null;
        try {
            logger.info((Object)("updating repository " + officialName + " compliance to : " + compliance));
            conn = this.openAireDataSource.getConnection();
            PreparedStatement stm = conn.prepareStatement("UPDATE datasources SET openairecompatibilityclass=?, dateofvalidation=?, activationid = ? , openairecompatibilityscheme = ? WHERE id = ?");
            Date utilDate = new Date();
            Timestamp date = new Timestamp(utilDate.getTime());
            Map<String, String> compMap = this.getRepoCompatibility(officialName, datasourceId);
            String newCompliance = "";
            if (compliance.equalsIgnoreCase("openaire2.0")) {
                newCompliance = compMap.containsValue("driver") && compMap.containsValue("openaire") ? "driver-openaire2.0-openaire3.0" : (compMap.containsValue("driver") ? "driver-openaire2.0" : (compMap.containsValue("openaire") ? "openaire2.0-openaire3.0" : "openaire2.0"));
            } else if (compliance.equalsIgnoreCase("driver")) {
                newCompliance = compMap.containsValue("ec_fundedresources") && compMap.containsValue("openaire") ? "driver-openaire2.0-openaire3.0" : (compMap.containsValue("ec_fundedresources") ? "driver-openaire2.0" : (compMap.containsValue("openaire") ? "driver-openaire3.0" : "driver"));
            } else if (compliance.equalsIgnoreCase("openaire3.0")) {
                newCompliance = compMap.containsValue("ec_fundedresources") && compMap.containsValue("driver") ? "driver-openaire2.0-openaire3.0" : (compMap.containsValue("ec_fundedresources") ? "openaire2.0-openaire3.0" : (compMap.containsValue("driver") ? "driver-openaire3.0" : "openaire3.0"));
            } else if (compliance.equalsIgnoreCase("openaire2.0_data")) {
                newCompliance = "openaire2.0";
            } else if (compliance.equalsIgnoreCase("notCompatible")) {
                newCompliance = compMap.containsValue("ec_fundedresources") && compMap.containsValue("driver") && compMap.containsValue("openaire") ? "driver-openaire2.0-openaire3.0" : (compMap.containsValue("ec_fundedresources") && compMap.containsValue("driver") ? "driver-openaire2.0" : (compMap.containsValue("openaire") ? "openaire3.0" : (compMap.containsValue("ec_fundedresources") ? "openaire2.0" : (compMap.containsValue("driver") ? "driver" : "notCompatible"))));
            }
            stm.setString(1, newCompliance);
            stm.setTimestamp(2, date);
            stm.setString(3, null);
            stm.setString(4, "dnet:compatibilityLevel");
            stm.setString(5, datasourceId);
            stm.executeUpdate();
            stm.close();
            conn.commit();
            logger.debug((Object)(officialName + " set as openaire compliant: " + compliance));
        }
        catch (SQLException e) {
            logger.error((Object)("error connecting to openaire db to set a repo as openaire compliant " + officialName), (Throwable)e);
            ret = false;
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    ret = false;
                    logger.error((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
        return ret;
    }
}

