/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.issn;

import eu.dnetlib.api.enabling.ISSNService;
import eu.dnetlib.api.enabling.ISSNServiceException;
import eu.dnetlib.domain.enabling.Subscription;
import gr.uoa.di.driver.enabling.issn.SubscriptionManager;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SubscriptionManagerImpl
implements SubscriptionManager {
    private static Logger logger = Logger.getLogger(SubscriptionManagerImpl.class);
    private ServiceLocator<ISSNService> snLocator = null;
    private ScheduledExecutorService executor = null;
    private List<Subscription> refreshList = new ArrayList<Subscription>();
    private int threads = 3;
    private int timeToLive = 3600;

    public void setSnLocator(ServiceLocator<ISSNService> snLocator) {
        this.snLocator = snLocator;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void init() {
        logger.debug((Object)("Creating thread pool (size: " + this.threads + ")"));
        this.executor = Executors.newScheduledThreadPool(this.threads);
        logger.debug((Object)("Adding refresh task (period: " + this.timeToLive + " sec)"));
        this.executor.scheduleAtFixedRate(new RefreshTask(), (long)(0.8 * (double)this.timeToLive), this.timeToLive, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.debug((Object)"Stopping thread pool");
        this.executor.shutdownNow();
        logger.debug((Object)"unsubscribing active subscriptions");
        List<Subscription> list = this.refreshList;
        synchronized (list) {
            for (Subscription sub : this.refreshList) {
                try {
                    this.snLocator.getService().unsubscribe(sub.getId());
                }
                catch (ISSNServiceException e) {
                    logger.error((Object)"Error unsubscibing", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void subscribe(Subscription subscription) {
        this.subscribe(subscription, true);
    }

    @Override
    public void subscribe(Subscription subscription, boolean refresh) {
        if (refresh) {
            subscription.setTimeToLive(this.timeToLive);
        }
        logger.debug((Object)("Subscribing with ttl " + subscription.getTimeToLive()));
        logger.debug((Object)("Subscribing epr " + subscription.getEpr()));
        logger.debug((Object)("Subscribing topic " + subscription.getTopic()));
        this.executor.submit(new SubscriptionTask(subscription, refresh));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(String subscriptionId) {
        try {
            this.snLocator.getService().unsubscribe(subscriptionId);
        }
        catch (ISSNServiceException e) {
            logger.error((Object)"Error unsubscibing", (Throwable)e);
        }
        List<Subscription> list = this.refreshList;
        synchronized (list) {
            for (int i = 0; i < this.refreshList.size(); ++i) {
                if (!this.refreshList.get(i).getId().equals(subscriptionId)) continue;
                this.refreshList.remove(i);
                break;
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)"Refreshing subscriptions");
            List list = SubscriptionManagerImpl.this.refreshList;
            synchronized (list) {
                for (Subscription sub : SubscriptionManagerImpl.this.refreshList) {
                    logger.debug((Object)("Refreshing subscription with id " + sub.getId()));
                    try {
                        ((ISSNService)SubscriptionManagerImpl.this.snLocator.getService()).renew(sub.getId(), SubscriptionManagerImpl.this.timeToLive);
                    }
                    catch (ISSNServiceException e) {
                        logger.error((Object)"Error renewing subscription", (Throwable)e);
                    }
                }
            }
        }
    }

    private class SubscriptionTask
    implements Runnable {
        private Subscription subscription = null;
        private boolean addToList = true;

        public SubscriptionTask(Subscription subscription, boolean addToList) {
            this.subscription = subscription;
            this.addToList = addToList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                try {
                    logger.debug((Object)("Adding new subscription : " + this.subscription));
                    logger.debug((Object)("Epr: " + this.subscription.getEpr()));
                    logger.debug((Object)("Topic: " + this.subscription.getTopic()));
                    String subId = ((ISSNService)SubscriptionManagerImpl.this.snLocator.getService()).subscribe(this.subscription.getEpr(), this.subscription.getTopic(), this.subscription.getTimeToLive());
                    logger.debug((Object)("Subscription id: " + subId));
                    this.subscription.setId(subId);
                    if (!this.addToList) break block5;
                    logger.debug((Object)("Adding subscription " + subId + " to refresh list"));
                    List list = SubscriptionManagerImpl.this.refreshList;
                    synchronized (list) {
                        SubscriptionManagerImpl.this.refreshList.add(0, this.subscription);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)t);
                }
            }
        }
    }
}

