/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.registry;

import eu.dnetlib.api.enabling.ISRegistryService;
import eu.dnetlib.api.enabling.ISRegistryServiceException;
import eu.dnetlib.domain.DriverResource;
import gr.uoa.di.driver.enabling.ISRegistry;
import gr.uoa.di.driver.enabling.ISRegistryException;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class ISRegistryImpl<D extends DriverResource>
implements ISRegistry<D> {
    private static Logger logger = Logger.getLogger(ISRegistry.class);
    private ServiceLocator<ISRegistryService> registryLocator = null;
    private ResourceToXmlConverter<D> converter = null;
    private String resourceUri = null;

    @Override
    public D save(D object) throws ISRegistryException {
        try {
            String profileId = object.getResourceId();
            if (object.getResourceUri() == null) {
                object.setResourceUri(this.resourceUri);
            }
            String xml = this.converter.ObjectToXml(object);
            if (profileId == null) {
                logger.debug((Object)("Saving profile: " + xml));
                profileId = this.registryLocator.getService().registerProfile(xml);
                object.setResourceId(profileId);
                logger.debug((Object)"done");
            } else {
                logger.debug((Object)("updating profile: " + xml));
                this.registryLocator.getService().updateProfile(profileId, xml, object.getResourceType());
                logger.debug((Object)"done");
            }
        }
        catch (ISRegistryServiceException rse) {
            throw new ISRegistryException("Error saving object", rse);
        }
        catch (JAXBException je) {
            throw new ISRegistryException("Error saving object", je);
        }
        return object;
    }

    @Override
    public void delete(D object) throws ISRegistryException {
        try {
            String profileId = object.getResourceId();
            this.registryLocator.getService().deleteProfile(profileId);
        }
        catch (ISRegistryServiceException rse) {
            throw new ISRegistryException("Error deleting profile", rse);
        }
    }

    @Override
    public D insertForValidation(D object) throws ISRegistryException {
        try {
            if (object.getResourceUri() == null) {
                object.setResourceUri(this.resourceUri);
            }
            String id = this.registryLocator.getService().insertProfileForValidation(object.getResourceType(), this.converter.ObjectToXml(object));
            object.setResourceId(id);
            return object;
        }
        catch (ISRegistryServiceException e) {
            throw new ISRegistryException("Error inserting profile for validation", e);
        }
        catch (JAXBException e) {
            throw new ISRegistryException("Error inserting profile for validation", e);
        }
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public void setConverter(ResourceToXmlConverter<D> converter) {
        this.converter = converter;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

