/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositorySearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.repository.RESOURCEPROFILE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;

public class RepositoryXmlConverter
extends AbstractConverter<Repository>
implements ResourceToXmlConverter<Repository> {
    private final String collection;

    public RepositoryXmlConverter(Collection c) throws JAXBException {
        super(RESOURCEPROFILE.class);
        this.collection = c.getCollection();
    }

    public RepositoryXmlConverter() throws JAXBException {
        this(Collection.VALID);
    }

    @Override
    public String ObjectToXml(Repository repository) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return baos.toString();
    }

    @Override
    public Repository XmlToObject(String xml) throws JAXBException {
        Repository rep = new Repository();
        RESOURCEPROFILE profile = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        rep.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER().getValue());
        rep.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
        rep.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
        rep.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
        rep.setProtocol(profile.getHEADER().getPROTOCOL());
        return rep;
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((RepositorySearchCriteria)criteria);
    }

    public String toXQueryString(RepositorySearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        String xQuery = this.collection;
        ArrayList<String> predicates = new ArrayList<String>();
        if (criteria != null) {
            if (criteria.getContains() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[contains(lower-case(.), \"" + criteria.getContains().toLowerCase() + "\")]");
            }
            if (criteria.getStartsWith() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[starts-with(lower-case(.), \"" + criteria.getStartsWith().toLowerCase() + "\")]");
            }
            if (criteria.getEndsWith() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[ends-with(lower-case(.), \"" + criteria.getStartsWith().toLowerCase() + "\")]");
            }
            if (criteria.getOfficialName() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OFFICIAL_NAME[. = \"" + criteria.getOfficialName() + "\"]");
            }
            if (criteria.getHaveDocuments() != null) {
                predicates.add("$x//STATUS/NUMBER_OF_OBJECTS[. > 0]");
            }
            if (criteria.getAdminInfo() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/ADMIN_INFO[. = \"" + criteria.getAdminInfo() + "\"]");
            }
            if (criteria.getCountry() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/COUNTRY[. = \"" + criteria.getCountry() + "\"]");
            }
            if (criteria.getRegisteredBy() != null) {
                predicates.add("($x/RESOURCE_PROFILE/BODY/CONFIGURATION/REGISTERED_BY[. = \"" + criteria.getRegisteredBy() + "\"] or $x/RESOURCE_PROFILE/BODY/CONFIGURATION/ADMIN_INFO[. = \"" + criteria.getRegisteredBy() + "\"])");
            }
            if (criteria.isVerified().booleanValue()) {
                predicates.add("(if ($x/RESOURCE_PROFILE/BODY/CONFIGURATION/EXTRA_FIELDS) then $x/RESOURCE_PROFILE/BODY/CONFIGURATION/EXTRA_FIELDS/FIELD[key = \"VERIFIED\"]/value[. = \"YES\"] else true())");
            }
            for (int i = 0; i < predicates.size(); ++i) {
                String predicate = (String)predicates.get(i);
                xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
                xQuery = xQuery + predicate;
            }
        }
        xQuery = xQuery + " return $x";
        return xQuery;
    }

    public String toXQueryString(Repository repository) {
        String xQuery = this.collection;
        xQuery = xQuery + " let $date := xs:date($x/RESOURCE_PROFILE/BODY/CONFIGURATION/EXTRA_FIELDS/FIELD[key = \"REGISTER_DATE\"]/value)";
        return xQuery;
    }

    public static enum Collection {
        VALID("for $x in collection(\"/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType\") "),
        PENDING("for $x in collection(\"/db/DRIVER/PendingRepositoryResources/RepositoryServiceResourceType\") ");

        private final String collection;

        private Collection(String collection) {
            this.collection = collection;
        }

        public String getCollection() {
            return this.collection;
        }
    }
}

