/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.vocabulary;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.enabling.Vocabulary;
import eu.dnetlib.domain.enabling.VocabularySearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.vocabulary.VocabularyLoader;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ISVocabularyLoader
implements VocabularyLoader {
    private static Logger logger = Logger.getLogger(ISVocabularyLoader.class);
    private ISLookUp<Vocabulary> lookUp = null;

    @Override
    public Vocabulary getVocabulary(String vocabularyName, Locale locale, Locale defaultLocale) {
        logger.debug((Object)("Getting vocabulary with name " + vocabularyName + "_" + locale));
        Vocabulary vocabulary = null;
        VocabularySearchCriteria criteria = new VocabularySearchCriteria(vocabularyName + "_" + locale);
        if (vocabularyName == null) {
            logger.debug((Object)"There is no vocabulary name");
            return null;
        }
        try {
            vocabulary = this.lookUp.getUniqueResult((SearchCriteria)criteria);
            if (vocabulary == null && defaultLocale != null) {
                logger.debug((Object)"Getting vocabulary with default locale");
                criteria = defaultLocale == null || defaultLocale.equals(Locale.ROOT) ? new VocabularySearchCriteria(vocabularyName) : new VocabularySearchCriteria(vocabularyName + "_" + defaultLocale);
                vocabulary = this.lookUp.getUniqueResult((SearchCriteria)criteria);
            }
        }
        catch (ISLookUpException isle) {
            logger.debug((Object)("Error loading vocabulary " + vocabularyName), (Throwable)isle);
        }
        logger.debug((Object)("returning " + vocabulary));
        return vocabulary;
    }

    public void setLookUp(ISLookUp<Vocabulary> lookUp) {
        this.lookUp = lookUp;
    }

    public ISLookUp<Vocabulary> getLookUp() {
        return this.lookUp;
    }
}

