/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.vocabulary;

import eu.dnetlib.api.data.DatasourceManagerService;
import eu.dnetlib.api.data.DatasourceManagerServiceException;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.enabling.Vocabulary;
import gr.uoa.di.driver.enabling.vocabulary.VocabularyLoader;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RepositoryVocabularyLoader
implements VocabularyLoader {
    private ServiceLocator<DatasourceManagerService> datasourceManagerService = null;
    private Logger logger = Logger.getLogger(RepositoryVocabularyLoader.class);

    @Override
    public Vocabulary getVocabulary(String vocabularyName, Locale locale, Locale defaultloLocale) {
        List repositories = null;
        try {
            repositories = this.datasourceManagerService.getService().listAllDatasources();
        }
        catch (DatasourceManagerServiceException e) {
            this.logger.error((Object)"Error getting repositories.", (Throwable)e);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Repository rep : repositories) {
            map.put(rep.getOfficialName(), rep.getOfficialName());
        }
        Vocabulary vocabulary = new Vocabulary(vocabularyName, map);
        return vocabulary;
    }

    public void setDatasourceManagerService(ServiceLocator<DatasourceManagerService> datasourceManagerService) {
        this.datasourceManagerService = datasourceManagerService;
    }
}

