package gr.uoa.di.driver.enabling.registry;

import javax.xml.bind.JAXBException;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ISRegistryService;
import eu.dnetlib.api.enabling.ISRegistryServiceException;
import eu.dnetlib.domain.DriverResource;
import gr.uoa.di.driver.enabling.ISRegistry;
import gr.uoa.di.driver.enabling.ISRegistryException;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;

public class ISRegistryImpl<D extends DriverResource> implements ISRegistry<D> {
	private static Logger logger = Logger.getLogger(ISRegistry.class);

	private ServiceLocator<ISRegistryService> registryLocator = null;
	private ResourceToXmlConverter<D> converter = null;
	private String resourceUri = null;

	public D save(D object) throws ISRegistryException {
		try {
			String profileId = object.getResourceId();

			if (object.getResourceUri() == null) {
				object.setResourceUri(resourceUri);
			}
			
			String xml = converter.ObjectToXml(object);

			if (profileId == null) {
				logger.debug("Saving profile: " + xml);
				profileId = registryLocator.getService().registerProfile(
						xml);

				object.setResourceId(profileId);

				logger.debug("done");
			} else {
				logger.debug("updating profile: " + xml);
				registryLocator.getService().updateProfile(profileId, xml,
						object.getResourceType());
				logger.debug("done");
			}
		} catch (ISRegistryServiceException rse) {
			throw new ISRegistryException("Error saving object", rse);
		} catch (JAXBException je) {
			throw new ISRegistryException("Error saving object", je);
		}
		
		return object;
	}

	public void delete(D object) throws ISRegistryException {

		try {
			String profileId = object.getResourceId();

			registryLocator.getService().deleteProfile(profileId);
		} catch (ISRegistryServiceException rse) {
			throw new ISRegistryException("Error deleting profile", rse);
		}
	}

	@Override
	public D insertForValidation(D object) throws ISRegistryException {
		try {
			
			if (object.getResourceUri() == null) {
				object.setResourceUri(resourceUri);
			}
			
			String id = registryLocator.getService().insertProfileForValidation(
					object.getResourceType(), converter.ObjectToXml(object));
			
			object.setResourceId(id);
			
			return object;
		} catch (ISRegistryServiceException e) {
			throw new ISRegistryException(
					"Error inserting profile for validation", e);
		} catch (JAXBException e) {
			throw new ISRegistryException(
					"Error inserting profile for validation", e);
		}
	}

	public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}

	public void setConverter(ResourceToXmlConverter<D> converter) {
		this.converter = converter;
	}

	public void setResourceUri(String resourceUri) {
		this.resourceUri = resourceUri;
	}
}